#ifndef __TDE_CDECONFIG_H
#define __TDE_CDECONFIG_H

#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqradiobutton.h>
#include <tqhbox.h>
#include <tdeconfig.h>

class TQCheckBox;
class TQGroupBox;
class TQVBox;
class TQLabel;
class TQRadioButton;

class CdeConfig: public TQObject
{
	Q_OBJECT
  

	public:
		CdeConfig( TDEConfig* conf, TQWidget* parent );
		~CdeConfig();

	// These public signals/slots work similar to KCM modules
	signals:
		void changed();

	public slots:
		void load( TDEConfig* conf );	
		void save( TDEConfig* conf );
		void defaults();

	protected slots:
		void slotSelectionChanged();	// Internal use
		void slotSelectionChanged( int );
		
	private:
		TDEConfig*   	cdeConfig;
		TQCheckBox* 	cbColorBorder;
//		TQCheckBox* 	cbTitlebarButton;
		TQHBox* 	        groupBox;
		TQGroupBox* 	gbSlider;
		TQButtonGroup*	bgAlign;
};


#endif
