/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqiconset.h>

#ifdef USE_QT4

#include "Qt/q3cleanuphandler.h"

static TQIconFactory *defaultFac = 0;
static Q3SingleCleanupHandler<TQIconFactory> q_cleanup_icon_factory;

/*! \class TQIconFactory
  \ingroup advanced
  \brief The TQIconFactory class is used to create pixmaps for a QIconSet.

  By reimplementing createPixmap(), you can override QIconSet's
  default algorithm for computing pixmaps not supplied by the user.

  Call setAutoDelete(TRUE) if you want the factory to automatically
  delete itself when it is no longer needed by QIconSet.

  \sa QIconSet
*/

/*!
  Constructs an icon factory.
*/
TQIconFactory::TQIconFactory()
    : autoDel( 0 )
{
    count = 0;
}

/*!
  Destroys the object and frees any allocated resources.
*/
TQIconFactory::~TQIconFactory()
{
}

/*!
  Ceates a pixmap for \a iconSet with a certain \a size, \a mode, and
  \a state. Returns 0 if the default QIconSet algorithm should be
  used to create a pixmap that wasn't supplied by the user.

  It is the caller's responsibility to delete the returned pixmap.

  The default implementation always returns 0.
*/
QPixmap *TQIconFactory::createPixmap( const QIconSet& /* iconSet */,
				     QIconSet::Size /* size */,
				     QIconSet::Mode /* mode */,
				     QIconSet::State /* state */ )
{
    return 0;
}

/*!
    \fn void TQIconFactory::setAutoDelete( bool autoDelete )

    If \a autoDelete is TRUE, sets the icon factory to automatically
    delete itself when it is no longer referenced by any QIconSet and
    isn't the default factory. If \a autoDelete is FALSE (the default)
    auto-deletion is disabled.

    \sa autoDelete(), defaultFactory()
*/

/*!
  \fn bool TQIconFactory::autoDelete() const

  Returns TRUE if auto-deletion is enabled; otherwise returns FALSE.

  \sa setAutoDelete()
*/

/*!
  Returns the default icon factory.

  \sa installDefaultFactory()
*/
TQIconFactory *TQIconFactory::defaultFactory()
{
    if ( !defaultFac ) {
	defaultFac = new TQIconFactory;
	defaultFac->setAutoDelete( TRUE );
	defaultFac->ref();
	q_cleanup_icon_factory.set( &defaultFac );
    }
    return defaultFac;
}

/*!
  Replaces the default icon factory with \a factory.
*/
void TQIconFactory::installDefaultFactory( TQIconFactory *factory )
{
    if ( !factory )
	return;

    factory->ref();
    if ( defaultFac && defaultFac->deref() && defaultFac->autoDelete() )
	delete defaultFac;
    defaultFac = factory;
    q_cleanup_icon_factory.set( &defaultFac );
}

/**
  A little do-nothing function to allow Qt3 code compatibility.
*/
void QIconSet::installIconFactory( TQIconFactory *factory )
{
    #warning "QIconSet::installIconFactory( QIconFactory *factory ) unimplemented!"
}

#endif // USE_QT4
