/* This file is part of the KDE libraries
    Copyright (C) 1997 Martin Jones (mjones@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
//-----------------------------------------------------------------------------
// KDE color selection dialog.
//
// 1999-09-27 Espen Sand <espensa@online.no>
// KColorDialog is now subclassed from KDialogBase. I have also extended
// KColorDialog::getColor() so that in contains a parent argument. This
// improves centering capability.
//
// layout management added Oct 1997 by Mario Weilguni
// <mweilguni@sime.com>
//


#include <stdio.h>
#include <stdlib.h>

#include <tqdrawutil.h>
#include <tqevent.h>
#include <tqfile.h>
#include <tqimage.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <klineedit.h>
#include <tqvalidator.h>
#include <tqpainter.h>
#include <tqpushbutton.h>
#include <tqtimer.h>

#include <kcolordialog.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <tdeglobalsettings.h>
#include <kiconloader.h>
#include <tdelistbox.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kseparator.h>
#include <kpalette.h>
#include <kimageeffect.h>

#include "colorcombo.h"
#include "colorcombo.moc"

// This is repeated from the KColorDlg, but I didn't
// want to make it public BL.
// We define it out when compiling with --enable-final in which case
// we use the version defined in KColorDlg

#define STANDARD_PAL_SIZE 17

ColorCombo::ColorCombo( TQWidget *parent, const char *name )
  : TQComboBox( parent, name )
{
  customColor.setRgb( 255, 255, 255 );
  internalcolor.setRgb( 255, 255, 255 );

  hascolor = false;

  createStandardPalette();

  addColors();

  connect( this, TQT_SIGNAL( activated(int) ), TQT_SLOT( slotActivated(int) ) );
  connect( this, TQT_SIGNAL( highlighted(int) ), TQT_SLOT( slotHighlighted(int) ) );
}

ColorCombo::~ColorCombo()
{
  delete []standardPalette;
  delete []standardPaletteNames;
}

/**
   Sets the current color
 */
void ColorCombo::setColor( const TQColor &col )
{
  internalcolor = col;
  hascolor = true;

  addColors();
}


/**
   Returns the currently selected color
 */
TQColor ColorCombo::color() const {
  return internalcolor;
}


bool ColorCombo::hasColor() const{
  return hascolor;
}


void ColorCombo::setColorName( const TQString &color )
{

  TQColor c(color);

  if ( c.isValid() && !color.isEmpty() ) {
    setColor( c );
  }
  else {
    hascolor = false;
    addColors();
  }

}

TQString ColorCombo::colorName()
{
  if ( hascolor ) {
    int i;

    for ( i = 0; i < STANDARD_PAL_SIZE; i++ )
      if ( standardPalette[i] == internalcolor )
          return standardPaletteNames[i];

    return internalcolor.name();

  }
  else
    return "";
}


void ColorCombo::resizeEvent( TQResizeEvent *re )
{
  TQComboBox::resizeEvent( re );

  addColors();
}

void ColorCombo::slotActivated( int index )
{
  hascolor = ( index != 0);

  if ( index == 1 )
  {
    if ( KColorDialog::getColor( customColor ) == TQDialog::Accepted )
    {
      TQRect rect( 0, 0, width(), 20 );
      TQPixmap pixmap( rect.width(), rect.height() );
      TQPainter painter;
      TQPen pen;

      if ( tqGray( customColor.rgb() ) < 128 )
        pen.setColor( white );
      else
        pen.setColor( black );

      painter.begin( &pixmap );
      TQBrush brush( customColor );
      painter.fillRect( rect, brush );
      painter.setPen( pen );
      painter.drawText( 2, painter.fontMetrics().height(),
            i18n("Custom...") );
      painter.end();

      changeItem( pixmap, 1 );
      pixmap.detach();
    }

    internalcolor = customColor;
  }
  else
    if ( index > 1 )
      internalcolor = standardPalette[ index - 2 ];

  emit activated( internalcolor );
}

void ColorCombo::slotHighlighted( int index )
{
  if ( index < 2 )
    internalcolor = customColor;
  else
    internalcolor = standardPalette[ index - 2 ];

  emit highlighted( internalcolor );
}

void ColorCombo::addColors()
{
  TQRect rect( 0, 0, width(), 20 );
  TQPixmap pixmap( rect.width(), rect.height() );
  TQPainter painter;
  TQPen pen;
  int i;

  clear();

  for ( i = 0; i < STANDARD_PAL_SIZE; i++ )
    if ( standardPalette[i] == internalcolor ) break;

  if ( i == STANDARD_PAL_SIZE )
    customColor = internalcolor;

  insertItem( i18n("None") );

  if ( tqGray( customColor.rgb() ) < 128 )
    pen.setColor( white );
  else
    pen.setColor( black );

  painter.begin( &pixmap );
  TQBrush brush( customColor );
  painter.fillRect( rect, brush );
  painter.setPen( pen );

  painter.drawText( 2, painter.fontMetrics().height(), i18n("Custom...") );
  painter.end();

  insertItem( pixmap );
  pixmap.detach();

  bool findColor = false;

  for ( i = 0; i < STANDARD_PAL_SIZE; i++ )
  {
    painter.begin( &pixmap );
    TQBrush brush( standardPalette[i] );
    painter.fillRect( rect, brush );
    painter.end();

    insertItem( pixmap );
    pixmap.detach();

    if ( standardPalette[i] == internalcolor ) {
      setCurrentItem( i + 2 );
      findColor = true;
    }
  }

  if ( !findColor )
    setCurrentItem(1);



  if ( !hascolor )
    setCurrentItem(0);

}

void ColorCombo::createStandardPalette()
{

    standardPalette = new TQColor [STANDARD_PAL_SIZE];

    int i = 0;

    standardPalette[i++] = TQt::red;
    standardPalette[i++] = TQt::green;
    standardPalette[i++] = TQt::blue;
    standardPalette[i++] = TQt::cyan;
    standardPalette[i++] = TQt::magenta;
    standardPalette[i++] = TQt::yellow;
    standardPalette[i++] = TQt::darkRed;
    standardPalette[i++] = TQt::darkGreen;
    standardPalette[i++] = TQt::darkBlue;
    standardPalette[i++] = TQt::darkCyan;
    standardPalette[i++] = TQt::darkMagenta;
    standardPalette[i++] = TQt::darkYellow;
    standardPalette[i++] = TQt::white;
    standardPalette[i++] = TQt::lightGray;
    standardPalette[i++] = TQt::gray;
    standardPalette[i++] = TQt::darkGray;
    standardPalette[i++] = TQt::black;


    standardPaletteNames = new TQString [STANDARD_PAL_SIZE];

    i = 0;

    standardPaletteNames[i++] = "red";
    standardPaletteNames[i++] = "green";
    standardPaletteNames[i++] = "blue";
    standardPaletteNames[i++] = "cyan";
    standardPaletteNames[i++] = "magenta";
    standardPaletteNames[i++] = "yellow";
    standardPaletteNames[i++] = "darkRed";
    standardPaletteNames[i++] = "darkGreen";
    standardPaletteNames[i++] = "darkBlue";
    standardPaletteNames[i++] = "darkCyan";
    standardPaletteNames[i++] = "darkMagenta";
    standardPaletteNames[i++] = "darkYellow";
    standardPaletteNames[i++] = "white";
    standardPaletteNames[i++] = "lightGray";
    standardPaletteNames[i++] = "gray";
    standardPaletteNames[i++] = "darkGray";
    standardPaletteNames[i++] = "black";
}
