/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef HIRARCHYVIEW_H
#define HIRARCHYVIEW_H

#include <tqvariant.h>
#include <tqlistview.h>
#include <tqtabwidget.h>
#include <tqguardedptr.h>
#include <tqcom_p.h>

class FormWindow;
class TQCloseEvent;
class TQPopupMenu;
class TQKeyEvent;
class TQMouseEvent;
class TQWizard;
class TQToolBox;

class HierarchyItem:public TQListViewItem
{
public:
  enum Type
  {
    Widget,
    SlotParent,
    Public,
    Protected,
    Private,
    Slot,
    DefinitionParent,
    Definition,
    Event,
    EventFunction
  };

    HierarchyItem(Type type, TQListViewItem * parent,
      const TQString & txt1, const TQString & txt2, const TQString & txt3);
    HierarchyItem(Type type, TQListView * parent,
      const TQString & txt1, const TQString & txt2, const TQString & txt3);

  void paintCell(TQPainter * p, const TQColorGroup & cg, int column, int width, int align);
  void updateBackColor();

  void setWidget(TQWidget * w);
  TQWidget *widget() const;

  void setText(int col, const TQString & txt)    {if (!txt.isEmpty()) TQListViewItem::setText(col, txt);}
  int rtti() const                              { return (int) typ;}

private:
  void okRename(int col);
  void cancelRename(int col);

private:
  TQColor backgroundColor();
  TQColor backColor;
  TQWidget *wid;
  Type typ;
};

class HierarchyList:public TQListView
{
  Q_OBJECT
  
public:
  HierarchyList(TQWidget * parent, FormWindow * fw, bool doConnects = TRUE);

  virtual void setup();
  virtual void setCurrent(TQWidget * w);
  void setOpen(TQListViewItem * i, bool b);
  void changeNameOf(TQWidget * w, const TQString & name);
  void changeDatabaseOf(TQWidget * w, const TQString & info);
  void setFormWindow(FormWindow * fw)   {formWindow = fw;}
  void drawContentsOffset(TQPainter * p, int ox, int oy, int cx, int cy, int cw, int ch)
        { setUpdatesEnabled(FALSE);  triggerUpdate();  setUpdatesEnabled(TRUE);
         TQListView::drawContentsOffset(p, ox, oy, cx, cy, cw, ch); }
  void insertEntry(TQListViewItem * i, const TQPixmap & pix = TQPixmap(), const TQString & s =
      TQString());

protected:
  void keyPressEvent(TQKeyEvent * e);
  void keyReleaseEvent(TQKeyEvent * e);
  void viewportMousePressEvent(TQMouseEvent * e);
  void viewportMouseReleaseEvent(TQMouseEvent * e);

public slots: 
  void addTabPage();
  void removeTabPage();

private:
  void insertObject(TQObject * o, TQListViewItem * parent);
  TQWidget *findWidget(TQListViewItem * i);
  TQListViewItem *findItem(TQWidget * w);
  TQWidget *current() const;

  private slots: virtual void objectClicked(TQListViewItem * i);
  virtual void showRMBMenu(TQListViewItem *, const TQPoint &);

protected:
  FormWindow * formWindow;
  TQPopupMenu *normalMenu, *tabWidgetMenu;
  bool deselect;
};

class HierarchyView : public TQTabWidget
{
    Q_OBJECT
    

public:
    HierarchyView( TQWidget *parent );
    ~HierarchyView();

    void setFormWindow( FormWindow *fw, TQWidget *w );
    FormWindow *formWindow() const;
    void clear();
    void widgetInserted( TQWidget *w );
    void widgetRemoved( TQWidget *w );
    void widgetsInserted( const TQWidgetList &l );
    void widgetsRemoved( const TQWidgetList &l );
    void namePropertyChanged( TQWidget *w, const TQVariant &old );
    void databasePropertyChanged( TQWidget *w, const TQStringList& info );
    void tabsChanged( TQTabWidget *w );
    void tabsChanged( TQToolBox *w );
    void pagesChanged( TQWizard *w );
    void rebuild();
    void closed( FormWindow *fw );

protected slots:

protected:
    void closeEvent( TQCloseEvent *e );

signals:
    void hidden();

private:
    FormWindow *formwindow;
    HierarchyList *listview;

};


#endif
