#!/bin/bash
set -e
tdesrc=$PWD
rm -rf $tdesrc/out

. $tdesrc/environment

compile_directory() {  
  cd $tdesrc/$1
  dir=$PWD
  for pkg in $2; do
    if [[ $pkg != .* ]]; then
      cd "$dir"/tde-"$pkg"
      makepkg -Lsci
    fi
  done
}

### Build Packages
compile_directory tde-core "cmake-trinity tqt3 tqtinterface arts dbus-tqt dbus-1-tqt tqca tqca-tls libart-lgpl avahi-tqt tdelibs tdebase"
compile_directory tde-libs "libcaldav libcarddav libkdcraw libkexiv2"
compile_directory tde-base "i18n tdeartwork tdebindings tdegraphics tdeutils tdeadmin"
compile_directory tde-extra "akode tdepim tdemultimedia tdenetwork tdeedu tdegames tdetoys tdeaccessibility tdeaddons gtk-qt-engine gtk3-tqt-engine systemsettings abakus amarok basket kmplayer krusader ksplash-engine-moodin style-qtcurve tdenetworkmanager tdepowersave tdesudo tdmtheme tork twin-style-crystal yakuake"
compile_directory tde-devel "tdesdk tdevelop tdewebdev"

### Copy completed packages to out folder and download dependencies to out folder
cd $tdesrc
mkdir -p $tdesrc/out
cp $(find $tdesrc -name *.pkg.tar.zst) $tdesrc/out
wget https://mirror.ppa.trinitydesktop.org/trinity/archlinux/htdig-3.2.0b6-11-x86_64.pkg.tar.xz -O $tdesrc/out/htdig-3.2.0b6-11-x86_64.pkg.tar.xz
wget https://mirror.ppa.trinitydesktop.org/trinity/archlinux/lcms-1.19-7-x86_64.pkg.tar.xz -O $tdesrc/out/lcms-1.19-7-x86_64.pkg.tar.xz
wget https://mirror.ppa.trinitydesktop.org/trinity/archlinux/pod2man-5.30.2-1-x86_64.pkg.tar.zst -O $tdesrc/out/pod2man-5.30.2-1-x86_64.pkg.tar.zst
wget https://mirror.ppa.trinitydesktop.org/trinity/archlinux/python2-lcms-1.19-7-x86_64.pkg.tar.xz -O $tdesrc/out/python2-lcms-1.19-7-x86_64.pkg.tar.xz

### Create trinity pacman repo
repo-add $tdesrc/out/trinity.db.tar.gz $tdesrc/out/*.pkg.tar.{xz,zst}
