#!/usr/bin/env python
""" About the PyKDE Sampler

Defines the 'about' function to create a TDEAboutData instance for the
sampler application.
"""
from os.path import dirname, join
from tdecore import TDEAboutData


appName = 'pytdesampler'
progName = 'PyKDE Sampler'
authorName = 'Troy Melhase'
authorEmail = bugsEmailAddress = 'troy@gci.net'
version = '0.1'
shortDescription = 'The PyKDE Sampler'
licenseType = TDEAboutData.License_GPL_V2
copyrightStatement = '(c) 2006, %s' % (authorName, )
homePageAddress = 'http://www.riverbankcomputing.co.uk/pytde/'
aboutText = ("The application sampler for PyKDE.")
contributors = [] # module-level global for keeping the strings around; intentional


def about():
    """ creates TDEAboutData instance for the app

    """
    about = TDEAboutData(
        appName,
        progName,
        version,
        shortDescription,
        licenseType,
        copyrightStatement,
        aboutText,
        homePageAddress,
        bugsEmailAddress)
    about.addAuthor(authorName, '', authorEmail)

    try:
        contrib = open(join(dirname(__file__), 'contributors.txt'))
        contrib = [line.strip() for line in contrib]
        contrib = [line for line in contrib if not line.startswith('#')]
        for line in contrib:
            try:
                name, task, addr = [s.strip() for s in line.split(',')]
                contributors.append((name, task, addr))                            
            except:
                pass
    except:
        pass

    contributors.sort(lambda a, b:cmp(a[0], b[0]))
    for name, task, addr in contributors:
        about.addCredit(name, task, addr)

    return about
