#!/usr/bin/env python

"""$Id: cursor.py,v 1.1 2003/07/01 14:18:37 phil Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from python_tqt.qt import *

# cb_bits and cm_bits were generated by X bitmap program.

cb_width  = 32
cb_height = 32

# cursor bitmap
cb_bits = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x0f\x00" \
          "\x00\x06\x30\x00\x80\x01\xc0\x00\x40\x00\x00\x01" \
          "\x20\x00\x00\x02\x10\x00\x00\x04\x08\x3e\x3e\x08" \
          "\x08\x03\xe0\x08\xc4\x00\x00\x11\x04\x1e\x78\x10" \
          "\x02\x0c\x30\x20\x02\x40\x00\x20\x02\x40\x00\x20" \
          "\x02\x40\x00\x20\x02\x20\x04\x20\x02\x20\x04\x20" \
          "\x02\x10\x08\x20\x02\x08\x08\x20\x02\xf0\x07\x20" \
          "\x04\x00\x00\x10\x04\x00\x00\x10\x08\x00\xc0\x08" \
          "\x08\x3c\x30\x08\x10\xe6\x19\x04\x20\x00\x0f\x02" \
          "\x40\x00\x00\x01\x80\x01\xc0\x00\x00\x06\x30\x00" \
          "\x00\xf8\x0f\x00\x00\x00\x00\x00"

cm_width  = 32
cm_height = 32

# cursor bitmap mask
cm_bits = "\x00\x00\x00\x00\x00\xf8\x1f\x00\x00\xfe\x3f\x00" \
          "\x80\x07\xf0\x00\xc0\x01\xc0\x01\x60\x00\x00\x03" \
          "\x30\x00\x00\x06\x18\x00\x00\x0c\x0c\x3e\x3e\x18" \
          "\x0e\x03\xe0\x18\xc6\x00\x00\x31\x07\x1e\x78\x30" \
          "\x03\x0c\x30\x60\x03\x40\x00\x60\x03\x40\x00\x60" \
          "\x03\x40\x00\x60\x03\x20\x04\x60\x03\x20\x04\x60" \
          "\x03\x10\x08\x60\x03\x08\x08\x60\x03\xf0\x07\x60" \
          "\x06\x00\x00\x30\x06\x00\x00\x30\x0c\x00\xc0\x18" \
          "\x0c\x3c\x30\x18\x18\xe6\x19\x0c\x30\x00\x0f\x06" \
          "\x60\x00\x00\x03\xc0\x01\xc0\x01\x80\x07\xf0\x00" \
          "\x00\xfe\x3f\x00\x00\xf8\x0f\x00"

# The CursorView contains many labels with different cursors.
class CursorView( TQWidget ):		# cursor view
    def __init__( self ):
        TQWidget.__init__( self )
        # Constructs a cursor view.
#enum CursorShape { ArrowCursor, UpArrowCursor, CrossCursor, WaitCursor, IbeamCursor, SizeVerCursor, SizeHorCursor, SizeBDiagCursor, SizeFDiagCursor, SizeAllCursor, BlankCursor, SplitVCursor, SplitHCursor, PointingHandCursor, ForbiddenCursor, WhatsThisCursor, LastCursor = WhatsThisCursor, BitmapCursor = 24 }

        shape = [
                "ArrowCursor",    "UpArrowCursor",          "CrossCursor",
                "WaitCursor",     "IbeamCursor",            "SizeVerCursor",
                "SizeHorCursor",  "SizeBDiagCursor",        "SizeFDiagCursor",
                "SizeAllCursor",  "BlankCursor",            "SplitVCursor",
                "SplitHCursor",   "PointingHandCursor",     "ForbiddenCursor",
                "WhatsThisCursor"
                ]
        name = [
                "standard arrow cursor",        "upwards arrow", 
                "crosshair",                    "hourglass/watch",
                "ibeam/text entry",             "vertical resize",
                "horizontal resize",            "diagonal resize (/)",
                "diagonal resize (\)",          "all directions resize", 
                "blank/invisible cursor",       "vertical splitting", 
                "horziontal splitting",         "a pointing hand", 
                "a slashed circle",             "an arrow with a question mark"
                ]

        self.setCaption( "CursorView" ) # set window caption

        grid = TQGridLayout( self, 5, 4, 20 )

        i=0
        for y in range( 0, 4, 1 ) :	# create the small labels
            for x in range( 0, 4, 1 ) :
                label = TQLabel( self )
                label.setCursor( TQCursor(i) )
                label.setText( shape[i] );
                label.setAlignment( self.AlignCenter )
                label.setFrameStyle( TQFrame.Box | TQFrame.Raised )
                grid.addWidget( label, x, y )
                TQToolTip.add( label, name[i] )
                i += 1

        cb = TQBitmap( cb_width, cb_height, cb_bits, True )
        cm = TQBitmap( cm_width, cm_height, cm_bits, True )
        custom = TQCursor( cb, cm )		# create bitmap cursor

        label = TQLabel( self )			# create the big label
        label.setCursor( custom )
        label.setText( "Custom bitmap cursor" )
        TQToolTip.add( label, "custom bitmap cursor" )
        label.setAlignment( self.AlignCenter )
        label.setFrameStyle( TQFrame.Box | TQFrame.Sunken )
        grid.addMultiCellWidget( label, 4, 4, 0, 3 )
            
# Create and display a CursorView.
def main( args ):
    a = TQApplication(sys.argv)          # application object
    v = CursorView()                    # cursor view
    v.setCaption( "TQt Example - Cursors" )
    a.setMainWidget( v )
    v.show()
    
    a.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
