/*
 * This file is part of the Polkit-tqt project
 * Copyright (C) 2009 Jaroslav Reznik <jreznik@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB. If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef LISTENER_ADAPTER_P_H
#define LISTENER_ADAPTER_P_H

#include "tqobject.h"

#include "polkit-tqt-agent-listener.h"
#include "polkit-tqt-identity.h"
#include "polkit-tqt-details.h"

typedef struct _GList GList;
typedef struct _GCancellable GCancellable;
typedef struct _GAsyncResult GAsyncResult;
typedef struct _GSimpleAsyncResult GSimpleAsyncResult;
typedef struct _GError GError;
typedef int gboolean;
typedef char gchar;

class TQString;
template<typename> class TQValueList;


namespace PolkitTQt
{

namespace Agent
{

class AsyncResult;
class Listener;

class ListenerAdapter : public TQObject
{
  Q_OBJECT

  public:
    static ListenerAdapter* instance();
    ~ListenerAdapter()
    {
    }

    void polkit_tqt_listener_initiate_authentication(PolkitAgentListener *listener,
            const gchar *action_id, const gchar *message, const gchar *icon_name,
            PolkitDetails *details, const gchar *cookie, GList *identities,
            GCancellable *cancellable, GSimpleAsyncResult *result);

    gboolean polkit_tqt_listener_initiate_authentication_finish(PolkitAgentListener *listener,
            GAsyncResult *res, GError **error);

    void cancelled_cb(PolkitAgentListener *listener);

  private:
    void addListener(Listener *listener);
    void removeListener(Listener *listener);
    Listener* findListener(PolkitAgentListener *listener);

    explicit ListenerAdapter(TQObject *parent = nullptr);
    TQValueList<Listener*> m_listeners;

    // Disable copy
    ListenerAdapter(const ListenerAdapter&);
    ListenerAdapter& operator=(const ListenerAdapter&);

    static ListenerAdapter *m_theListenerAdapter;

    friend class Listener;
};

}

}

#endif
