/*
	Copyright (C) 2005 by Tobias Erbsland <te@profzone.ch>

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	version 2, License as published by the Free Software Foundation.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License
	along with this library; see the file COPYING.LIB.  If not, write to
	the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	Boston, MA 02110-1301, USA.
*/
#include "qtbuildconfig.h"
#include "cppsupportpart.h"

#include <domutil.h>

#include <kdebug.h>
#include <tqdom.h>

#include <stdlib.h>

const TQString QtBuildConfig::m_configRoot = TQString( "/kdevcppsupport/qt" );

QtBuildConfig::QtBuildConfig( CppSupportPart * part, TQDomDocument* dom )
	: TQObject( part ), m_part( part ), m_dom( dom )
{
	init();
}

QtBuildConfig::~QtBuildConfig()
{
}

void QtBuildConfig::init( )
{
	m_used = DomUtil::readBoolEntry( *m_dom, m_configRoot + "/used", false );
	m_version = DomUtil::readIntEntry( *m_dom, m_configRoot + "/version", 3 );
	if( m_version < 3 || m_version > 4 )
	{
		m_version = 3;
	}
	m_includeStyle = DomUtil::readIntEntry( *m_dom, m_configRoot + "/includestyle", 3 );
	if( m_includeStyle < 3 || m_includeStyle > 4 )
	{
		m_includeStyle = m_version;
	}
	m_root = DomUtil::readEntry( *m_dom, m_configRoot + "/root", "" );
    m_qmakePath = DomUtil::readEntry(*m_dom, m_configRoot + "/qmake", "");
    m_designerPath = DomUtil::readEntry(*m_dom, m_configRoot + "/designer", "");
    m_designerPluginPaths = DomUtil::readListEntry(*m_dom, m_configRoot + "/designerpluginpaths", "path" );

    if( m_root.isEmpty() || !isValidTQtDir( m_root ) )
    {
        findTQtDir();
    }
    if( m_qmakePath.isEmpty() || !isExecutable( m_qmakePath ) )
    {
        m_qmakePath = findExecutable( "qmake-qt"+ TQString::number( m_version ) );
        if( m_qmakePath.isEmpty() || !isExecutable( m_qmakePath ) )
            m_qmakePath = findExecutable( "qmake" );
    }
    if( m_designerPath.isEmpty() || !isExecutable( m_designerPath ) )
    {
        m_designerPath = findExecutable( "designer-qt"+TQString::number( m_version ) );
        if( m_designerPath.isEmpty() || !isExecutable( m_designerPath ) )
            m_designerPath = findExecutable( "designer" );
    }


	m_designerIntegration = DomUtil::readEntry( *m_dom, m_configRoot + "/designerintegration" );
	if( m_designerIntegration.isEmpty() )
	{
		if ( m_version == 3 )
			m_designerIntegration = "EmbeddedKDevDesigner";
		else
			m_designerIntegration = "ExternalDesigner";
	}
}

bool QtBuildConfig::isValidTQtDir( const TQString& path ) const
{
    TQFileInfo inc( path + TQString( TQChar( TQDir::separator() ) )+
                   "include"+TQString( TQChar( TQDir::separator() ) )+
                   "tqt.h" );
    return ( m_version == 4 || ( m_version != 4 && inc.exists() ) );
}

void QtBuildConfig::buildBinDirs( TQStringList & dirs ) const
{
    if( m_version == 3 )
    {
        if( !m_root.isEmpty() )
            dirs << (m_root + TQString( TQChar( TQDir::separator() ) ) + "bin");
        dirs << (::getenv("QTDIR") + TQString( TQChar( TQDir::separator() ) ) + "bin");
    }
    TQStringList paths = TQStringList::split(":",::getenv("PATH"));
    dirs += paths;
    TQString binpath = TQDir::rootDirPath() + "bin";
    if( dirs.findIndex( binpath ) != -1 )
        dirs << binpath;

    binpath = TQDir::rootDirPath() + "usr" + TQString( TQChar( TQDir::separator() ) ) + "bin";
    if( dirs.findIndex( binpath ) != -1 )
        dirs << binpath;
    binpath = TQDir::rootDirPath() + "usr" + TQString( TQChar( TQDir::separator() ) ) + "local" + TQString( TQChar( TQDir::separator() ) ) + "bin";
    if( dirs.findIndex( binpath ) != -1 )
        dirs << binpath;
}


TQString QtBuildConfig::findExecutable( const TQString& execname ) const
{
    TQStringList dirs;
    buildBinDirs( dirs );

    for( TQStringList::Iterator it=dirs.begin(); it!=dirs.end(); ++it )
    {
        TQString designer = *it + TQString( TQChar( TQDir::separator() ) ) + execname;
        if( !designer.isEmpty() && isExecutable( designer ) )
        {
            return designer;
        }
    }
    return "";
}

bool QtBuildConfig::isExecutable( const TQString& path ) const
{
    TQFileInfo fi(path);
    return( fi.exists() && fi.isExecutable() );
}

void QtBuildConfig::findTQtDir()
{
    TQStringList qtdirs;
    if( m_version == 3 )
        qtdirs.push_back( ::getenv("QTDIR") );
    qtdirs.push_back( TQDir::rootDirPath()+"usr"+TQString( TQChar( TQDir::separator() ) )+"lib"+TQString( TQChar( TQDir::separator() ) )+"qt"+TQString("%1").arg( m_version ) );
    qtdirs.push_back( TQDir::rootDirPath()+"usr"+TQString( TQChar( TQDir::separator() ) )+"lib"+TQString( TQChar( TQDir::separator() ) )+"qt"+TQString( TQChar( TQDir::separator() ) )+TQString("%1").arg( m_version ) );
    qtdirs.push_back( TQDir::rootDirPath()+"usr"+TQString( TQChar( TQDir::separator() ) )+"share"+TQString( TQChar( TQDir::separator() ) )+"qt"+TQString("%1").arg( m_version ) );
    qtdirs.push_back( TQDir::rootDirPath()+"usr" );
    qtdirs.push_back( TQDir::rootDirPath()+"usr"+TQString( TQChar( TQDir::separator() ) )+"lib"+TQString( TQChar( TQDir::separator() ) )+"qt" );

    for( TQStringList::Iterator it=qtdirs.begin(); it!=qtdirs.end(); ++it )
    {
        TQString qtdir = *it;
        if( !qtdir.isEmpty() && isValidTQtDir(qtdir) )
        {
            m_root = qtdir;
            return;
        }
    }
}

void QtBuildConfig::store( )
{
	DomUtil::writeBoolEntry( *m_dom, m_configRoot + "/used", m_used );
	DomUtil::writeIntEntry( *m_dom, m_configRoot + "/version", m_version );
	DomUtil::writeIntEntry( *m_dom, m_configRoot + "/includestyle", m_includeStyle );
	DomUtil::writeEntry( *m_dom, m_configRoot + "/root", m_root );
	DomUtil::writeEntry( *m_dom, m_configRoot + "/designerintegration", m_designerIntegration );
    DomUtil::writeEntry(*m_dom, m_configRoot + "/qmake", m_qmakePath );
    DomUtil::writeEntry(*m_dom, m_configRoot + "/designer", m_designerPath );
    DomUtil::writeListEntry(*m_dom, m_configRoot + "/designerpluginpaths", "path",  m_designerPluginPaths );

	emit stored();
}

void QtBuildConfig::setUsed( bool used )
{
	m_used = used;
}

void QtBuildConfig::setVersion( int version )
{
	m_version = version;
}

void QtBuildConfig::setIncludeStyle( int style )
{
	m_includeStyle = style;
}

void QtBuildConfig::setRoot( const TQString& root )
{
	m_root = root;
}

void QtBuildConfig::setTQMakePath( const TQString& path )
{
    m_qmakePath = path;
}

void QtBuildConfig::setDesignerPluginPaths( const TQStringList& pfx )
{
    m_designerPluginPaths = pfx;
}

void QtBuildConfig::setDesignerPath( const TQString& path )
{
    m_designerPath = path;
}

void QtBuildConfig::setDesignerIntegration( const TQString& designerIntegration )
{
	m_designerIntegration = designerIntegration;
}
#include "qtbuildconfig.moc"
