/*
    msnnotifysocket.h - Notify Socket for the MSN Protocol

    Copyright (c) 2002      by Duncan Mac-Vicar Prett <duncan@kde.org>
    Copyright (c) 2002-2003 by Martijn Klingens       <klingens@kde.org>
    Copyright (c) 2002-2005 by Olivier Goffart        <ogoffart at kde.org>
    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>
    Copyright (c) 2005      by Gregg Edghill          <gregg.edghill@gmail.com>

    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    Portions taken from
    KMerlin   (c) 2001      by Olaf Lueg              <olueg@olsd.de>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef MSNNOTIFYSOCKET_H
#define MSNNOTIFYSOCKET_H

#include "msnsocket.h"
#include "msnprotocol.h"


class MSNDispatchSocket;
class MSNAccount;
class KTempFile;
class MSNSecureLoginHandler;
class MSNChallengeHandler;

/**
 * @author Olaf Lueg
 * @author Olivier Goffart
 */
class MSNNotifySocket : public MSNSocket
{
	Q_OBJECT
  

public:
	MSNNotifySocket( MSNAccount* account, const TQString &msnId, const TQString &password );
	~MSNNotifySocket();

	virtual void disconnect();

	void setStatus( const Kopete::OnlineStatus &status );
	void addContact( const TQString &handle, int list, const TQString& publicName, const TQString& contactGuid, const TQString& groupGuid );
	void removeContact( const TQString &handle, int list, const TQString &contactGuid, const TQString &groupGuid );

	void addGroup( const TQString& groupName );
	void removeGroup( const TQString& group );
	void renameGroup( const TQString& groupName, const TQString& groupGuid );

	void changePublicName( const TQString& publicName , const TQString &handle=TQString() );
	void changePersonalMessage( MSNProtocol::PersonalMessageType type , const TQString& personalMessage );

	void changePhoneNumber( const TQString &key, const TQString &data );

	void createChatSession();

	void sendMail(const TQString &email);

	/**
	 * this should return a  Kopete::Account::DisconnectReason value
	 */
	int  disconnectReason() { return m_disconnectReason; }

	TQString localIP() { return m_localIP; }

	bool setUseHttpMethod( bool useHttpMethod );

	bool isLogged() const { return m_isLogged; }

public slots:
	void slotOpenInbox();
	void slotMSNAlertLink(unsigned int action);
	void slotMSNAlertUnwanted();

signals:
	void newContactList();
	void contactList(const TQString& handle, const TQString& publicName, const TQString &contactGuid, uint lists, const TQString& groups);
	void contactStatus(const TQString&, const TQString&, const TQString& );
	void contactAdded(const TQString& handle, const TQString& list, const TQString& publicName, const TQString& contactGuid, const TQString& groupGuid);
	//void contactRemoved(const TQString&, const TQString&, uint);
	void contactRemoved(const TQString& handle, const TQString& list, const TQString& contactGuid, const TQString& groupGuid);

	void groupListed(const TQString&, const TQString&);
	void groupAdded( const TQString&, const TQString&);
	void groupRenamed( const TQString&, const TQString& );
	void groupRemoved( const TQString& );

	void invitedToChat(const TQString&, const TQString&, const TQString&, const TQString&, const TQString& );
	void startChat( const TQString&, const TQString& );

	void statusChanged( const Kopete::OnlineStatus &newStatus );

	void hotmailSeted(bool) ;


	/**
	 * When the dispatch server sends us the notification server to use, this
	 * signal is emitted. After this the socket is automatically closed.
	 */
	void receivedNotificationServer( const TQString &host, uint port );


protected:
	/**
	 * Handle an MSN command response line.
	 */
	virtual void parseCommand( const TQString &cmd, uint id,
		const TQString &data );

	/**
	 * Handle an MSN error condition.
	 * This reimplementation handles most of the other MSN error codes.
	 */
	virtual void handleError( uint code, uint id );

	/**
	 * This reimplementation sets up the negotiating with the server and
	 * suppresses the change of the status to online until the handshake
	 * is complete.
	 */
	virtual void doneConnect();


private slots:
	/**
	 * We received a message from the server, which is sent as raw data,
	 * instead of cr/lf line-based text.
	 */
	void slotReadMessage( const TQByteArray &bytes );

	/**
	 * Send a keepalive to the server to avoid idle connections to cause
	 * MSN closing the connection
	 */
	void slotSendKeepAlive();

	void sslLoginFailed();
	void sslLoginIncorrect();
	void sslLoginSucceeded(TQString ticket);


private:
	/**
	 * Convert the MSN status strings to a Kopete::OnlineStatus
	 */
	Kopete::OnlineStatus convertOnlineStatus( const TQString &statusString );

	MSNAccount *m_account;
	TQString m_password;
	TQStringList m_msnAlertURLs;

	unsigned int mailCount;

	Kopete::OnlineStatus m_newstatus;

	/**
	 * Convert an entry of the Status enum back to a string
	 */
	TQString statusToString( const Kopete::OnlineStatus &status ) const;

	/**
	 * Process the CurrentMedia XML element.
	 * @param mediaXmlElement the source XML element as text.
	 */
	TQString processCurrentMedia( const TQString &mediaXmlElement );

	//know the last handle used
	TQString m_tmpLastHandle;
	TQMap <unsigned int,TQString> m_tmpHandles;
	TQString m_configFile;

	//for hotmail inbox opening
	bool m_isHotmailAccount;
	TQString m_MSPAuth;
	TQString m_kv;
	TQString m_sid;
	TQString m_loginTime;
	TQString m_localIP;
	MSNSecureLoginHandler *m_secureLoginHandler;

	MSNChallengeHandler *m_challengeHandler;
	TQTimer *m_keepaliveTimer;

	bool m_ping;

	int m_disconnectReason;

	/**
	 * Used to set the myself() personalMessage when the acknowledge(UUX) command is received.
	 * The personalMessage is built into @ref changePersonalMessage
	 */
	TQString m_propertyPersonalMessage;

	/**
	 * Used to tell when we are logged in to MSN Messeger service.
	 * Logged when we receive the initial profile message from Hotmail.
	 *
	 * Some commands only make sense to be done when logged.
	 */
	bool m_isLogged;
};

#endif
