/***************************************************************************
	kjwidget.cpp  -  Base Class for all widgets
	--------------------------------------
	Maintainer: Stefan Gehn <sgehn@gmx.net>

 ***************************************************************************/

// local includes
#include "kjwidget.h"
//#include <kdebug.h>

// ugly static functions and stuff
#include "helpers.cpp"

#include <tqpainter.h>

KJWidget::KJWidget(KJLoader *p) : mParent(p)
{
}

TQBitmap KJWidget::getMask(const TQImage &_rect, TQRgb transparent)
{
	TQImage result(_rect.width(), _rect.height(), 1,2, TQImage::LittleEndian);
	result.setColor(1, tqRgb(0,0,0));
	result.setColor(0, tqRgb(255,255,255));

	for(int height=0;height<_rect.height(); height++)
	{
		for(int width=0; width<_rect.width(); width++)
			setPixel1BPP(result, width, height, _rect.pixel(width, height)!=transparent);
	}
	TQBitmap bm;
	bm.convertFromImage(result);
	return bm;
}

void KJWidget::repaint(bool me, const TQRect &r, bool clear)
{
	TQPainter p(parent());
	if (me)
		paint(&p, r.isValid() ? r : rect());
	else
		parent()->repaint(r.isValid() ? r : rect(), clear);
}

const TQString &KJWidget::backgroundPressed(const TQString &bmp) const
{
	if(bmp.isEmpty()) // play safe
	{
//		kdDebug(66666) << k_funcinfo << "empty argument 'bmp', returning TQString()!" << endl;
		return TQString();
	}

//	kdDebug(66666) << k_funcinfo << "Returning pressed pixmap for '" << bmp.latin1() << "'" << endl;

	// make absolutely sure the wanted backgroundimagepressedX line is there
	TQStringList item = parser()["backgroundimagepressed"+TQString::number(bmp.mid(3).toInt())];
	if(item.count() < 2)
	{
//		kdDebug(66666) << k_funcinfo << "backgroundimagepressed doesn't have enough keys in its line!" << endl;
		return TQString();
	}
	else
		return item[1];
}
