/*
 *   Copyright (C) 2001 by Bernd Gehrmann bernd@kdevelop.org               *
 *   Copyright (C) 2002 by Eray Ozkural erayo@cs.bilkent.edu.tr            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _FILESELECTORWIDGET_H_
#define _FILESELECTORWIDGET_H_

#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqstrlist.h>
#include <tqtooltip.h>

#include <tdelistview.h>
#include <tqvbox.h>
#include <tqwidget.h>
#include <tdefile.h>
#include <kurlcombobox.h>
#include <kurlcompletion.h>
#include <kcombobox.h>
#include <kprotocolinfo.h>
#include <tdediroperator.h>

class DubPlayListItem;

class FileSelectorWidget : public TQWidget
{
  Q_OBJECT
  

  friend class DubPlayListItem;

public:
  FileSelectorWidget(TQWidget *parent);
  ~FileSelectorWidget();

  KDirOperator* dirOperator() {return dir;}
  KDirLister* dirLister() { return dir->dirLister(); }
  KURL currentDirectory();

public slots:
  void slotFilterChange(const TQString&);
  void setDir(KURL);

private slots:
  void cmbPathActivated( const KURL& u );
  void cmbPathReturnPressed( const TQString& u );
  void dirUrlEntered( const KURL& u );
  void dirFinishedLoading();
  void fileHighlighted(const KFileItem *);
  void fileSelected(const KFileItem *);
//	void setCurrentDocDir();

protected:
  void focusInEvent(TQFocusEvent*);

private:

  KURLComboBox *cmbPath;
  KHistoryCombo * filter;
  TQLabel* filterIcon;
  KDirOperator * dir;
  TQPushButton *home, *up, *back, *forward, *cfdir;

};

#endif
