/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEDITUNKNOWNVARIABLEDIALOG_H
#define QALCULATEEDITUNKNOWNVARIABLEDIALOG_H

#include <kdialogbase.h>

class TQLabel;
class KComboBox;
class KLineEdit;
class TQPushButton;
class MathStructure;
class QalculateEditNamesDialog;
class UnknownVariable;
class TQCheckBox;

/**
@author Niklas Knutsson
*/
class QalculateEditUnknownVariableDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateEditUnknownVariableDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditUnknownVariableDialog();

	UnknownVariable *editVariable(TQString category = TQString::null, UnknownVariable *v = NULL);

	QalculateEditNamesDialog *names_edit_dialog;
	UnknownVariable *edited_unknown;
	KComboBox *categoryCombo, *signCombo, *typeCombo;
	KLineEdit *nameEdit, *titleEdit;
	TQLabel *namesLabel, *signLabel, *typeLabel;
	TQPushButton *namesButton;
	TQCheckBox *assumptionsBox;

public slots:

	void editNames();
	void nameChanged(const TQString&);
	void signComboActivated(int);
	void typeComboActivated(int);

protected slots:
	
	void slotHelp();
	void slotOk();

};

#endif
