/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef RESIZABLEDRAGWIDGET_H
#define RESIZABLEDRAGWIDGET_H

#include "DragWidget.h"
#
/**
	@author Todor Gyumyushev <yodor@developer.bg>
*/
class ResizableDragWidget : public DragWidget
{
Q_OBJECT
  
public:
    ResizableDragWidget(TQWidget *parent, const char *name, WFlags f);
    ~ResizableDragWidget();

		void drawResizeHandle();
private:
	bool rsz;

protected:
	virtual void mouseMoveEvent ( TQMouseEvent * e );
	virtual void mousePressEvent ( TQMouseEvent * e );
	virtual void mouseReleaseEvent ( TQMouseEvent * e );
	virtual void paintEvent ( TQPaintEvent *e );
};

#endif
