/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _READER_H_
#define _READER_H_

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqfile.h>
#include <tqmap.h>
#include <tqpair.h>

#include <kdirwatch.h>
#include <kurl.h>


#include "globals.h"

#include "logListItem.h"
#include "logLine.h"
#include "logManager.h"

#include "logFile.h"
#include "logViewColumn.h"
#include "logViewColumns.h"

class View;

/**
 * @author Nicolas Ternisien
 */
class Reader : public TQObject {
	
	Q_OBJECT
  
	
	public:
		Reader(TQObject* parent=NULL, const char* name=NULL);
		
		~Reader();
		
		virtual void readLog()=0;
		virtual void initColumns(LogViewColumns* columns)=0;

		virtual void logChanged(LogFile* logFile);
		
		void setLogManager(LogManager* manager);

		void watchLogFile(LogFile* file);
		void watchLogFiles();

		void relaunchLogChanged();

		
	protected:
		TQFile* openFile(TQString name);
		void closeFile(TQFile* file);
			
	public slots:
		void logChanged(const TQString&);

	signals:
		void statusbarChanged(const TQString& message);
		void logUpdated(int lineTotal);
		
		void openingProgressed(int percent);
		
		void readingBegin();
		void readingFile(int currentFile);
		void readingEnd();
	
	protected:

		LogManager* logManager;
		
		KDirWatch* watch;

};

#endif
