/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef LOG_MANAGER_H
#define LOG_MANAGER_H

//TQt includes
#include <tqobject.h>
#include <tqpixmap.h>
#include <tqstringlist.h>
#include <tqfile.h>
#include <tqdatetime.h>
#include <tqlistview.h>

#include <tqptrlist.h>

#include <tqvaluevector.h>
#include <tqvaluelist.h>

//KDE includes
#include <kurl.h>

//Project includes
#include "globals.h"

#include "logLineList.h"
#include "logMode.h"
#include "logFile.h"
#include "logViewColumns.h"

class Reader;
class View;
class KSystemLog;
class LoadingDialog;

class LogManager;

typedef TQPtrList<LogManager> LogManagers;

/**
 * @author Nicolas Ternisien
 * TODO !!!!!!!!!!!!! Separate OpeningFileName from LogManager !!!!!!!!!!!!
 */
class LogManager : public TQObject {
	Q_OBJECT
  
	
	public:
	
		LogManager(KSystemLog* main, LoadingDialog* progress);
		
		virtual ~LogManager();
		
		View* getView();
		
		Reader* getReader();
		
		groupByType getGroupBy();
		int getGroupByColumn();
		
		TQTime& getLastUpdate();
		
		LogMode* getLogMode();
		void initialize(LogMode* mode);
				
		void setParsingPaused(bool paused);
		bool isParsingPaused();
		
		void setTooltipEnabled(bool enabled);
		bool isTooltipEnabled();

		void setNewLinesDisplayed(bool displayed);
		bool isNewLinesDisplayed();
		
		void clearView();
		
		int getIndex();
		
		void setGroupBy(groupByType group, int column=-1);
	
		void setCurrent(bool cur);
		bool isCurrent();
		
		LogViewColumns* getColumns();

		void reload();

		void setLogFiles(LogFiles* files);
		LogFiles& getLogFiles();

		void synchronize(LogLineList* buffer);


		void toggleFilterBar();
	
		void saveConfig();
	
	protected:	
		void reinitialize();
		
		void initView();
	
	public slots:
		void slotExpandAll();
		void slotCollapseAll();
		
		void slotCopyToClipboard();
		void slotFileSave();
		
		void slotSendMail();

		
	protected slots:
		
		//TODO Change the method name
		void slotOpenContextualMenu(TQListViewItem *item, const TQPoint& pos, int value);

		//Redirect the openingProgressed signal from Reader to connected object
		void openingProgress(int percent);
		
		void slotLogUpdated(int lineCount);
		
		void slotSelectionChanged();

		
		void slotChangeCaption(const TQString& message);
		void slotChangeStatusbar(const TQString& message);
		
		void slotDetails(TQListViewItem *, const TQPoint &, int);
		
		void readingBegun();
		void readingFile(int currentFile);
		void readingEnded();
		
	signals:
		void changeTitle(View* view, const TQString& label);
		void changeTitle(View* view, const TQIconSet& icon, const TQString& label);
		
		void changeCaption(const TQString& caption);
		void changeStatusbar(const TQString& message);
		
		void detailsCalled();
		
		void GUIUpdated();
		
		void selectionChanged();
		
		void reloaded();
		void logUpdated(int);

	protected:
		KSystemLog* main;
		
		TQTime lastUpdate;
		
		LogMode* logMode;
		

		bool sortOrder;
		
		int sortColumn;
		
		bool newLinesDisplayed;
		bool parsingPaused;
		bool tooltipEnabled;

		LogFiles logFiles;
		
		bool current;
		
		int newLinesSinceLastSelection;

		
		LoadingDialog* loadingDialog;
		
		Reader* reader;
		View* view;
		
		groupByType groupBy;
		int groupByColumn;
		
		LogViewColumns* columns;

};

#endif //LOG_MANAGER_H
