/***************************************************************************
 *
 * tdenetman.h - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2012 Timothy Pearson <kb9vqf@pearsoncomputing.net>
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *         Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_WIRELESS_DEVICE_TRAY_H
#define TDENETWORKMANAGER_WIRELESS_DEVICE_TRAY_H

// TDENM includes
#include "tdenetman.h"
#include "devicetraycomponent.h"
#include "tdenetman-wireless_network.h"

// predefinitions
class WirelessDevice;
class WirelessDeviceTrayPrivate;

class WirelessDeviceTray : public DeviceTrayComponent
{
	Q_OBJECT
  

	public:
		WirelessDeviceTray (TQString, KSystemTray * parent = 0, const char * name = 0);
		~WirelessDeviceTray ();

		void addMenuItems(TDEPopupMenu* menu);

	protected:
		/**
		 * Reimplementation
		 */
		TQStringList getToolTipText();

	public slots:
		void slotUpdateDeviceState(TDENetworkConnectionStatus::TDENetworkConnectionStatus, TDENetworkConnectionStatus::TDENetworkConnectionStatus, TQString);
		void slotCheckActiveAccessPoint();
		void newConnection();
		void newConnection(int);

	protected slots:
		void apPropertyChanged(TDEMACAddress BSSID, TDENetworkAPEventType::TDENetworkAPEventType event);
		void slotAccessPointAdded(TDENetworkWiFiAPInfo*);
		void slotAccessPointRemoved(TDEMACAddress);

	private slots:
		void tdeAccessPointStatusChangedHandler(TDEMACAddress, TDENetworkAPEventType::TDENetworkAPEventType);
		void sendUpdateUI();

	private:
		void addWirelessNetworks(TDEPopupMenu* menu);
		TQValueList<WirelessNetwork> getWirelessNetworks();
		TQValueList<TDEWiFiConnection*> getWirelessConnections();
		TDEWiFiConnection* findMatchingConnection(const WirelessNetwork& net, const TQValueList<TDEWiFiConnection*>& connection);
		bool findMatchingNetwork(const TDEWiFiConnection* conn, const TQValueList<WirelessNetwork>& nets, WirelessNetwork& net);
		void setPixmapForStates(TDENetworkConnectionStatus::TDENetworkConnectionStatus states, TQString pixmap);
		TQMap<int, TQByteArray> newWirelessPopupSSIDMap;

		WirelessDeviceTrayPrivate* d;
		TDEHardwareDevices* hwdevices;

};

#endif /* TDENETWORKMANAGER_WIRELESS_DEVICE_TRAY_H */
