//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICINTERFACELOGGING_H
#define KMFGENERICINTERFACELOGGING_H

#include <kmyfirewallgenericinterfacelogging.h>

/**
@author Christian Hubinger
*/

// QT includes
#include <tqstring.h>
#include <tqguardedptr.h>

class TQTimer;

namespace KMF {
class KMFNetwork;
class KMFGenericDoc;
class NetfilterObject;

class KMFGenericInterfaceLogging : public KMyFirewallGenericInterfaceLogging {
	Q_OBJECT
  
public:
	KMFGenericInterfaceLogging( TQWidget *parent = 0, const char *name = 0, WFlags f = 0 );

	~KMFGenericInterfaceLogging();


public slots:
	void slotUpdateView();
	void slotUpdateView( NetfilterObject* );

public:
	void loadDoc( KMFNetwork* );

private slots:
	void slotLoggingChanged( bool );
	void slotLimitChanged( bool );
	void slotLogPrefixChanged( const TQString & );

private:
	TQGuardedPtr<KMFNetwork> m_doc;
};
}
#endif
