/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "xsltexporter.h"
#include "xslthandler.h"
#include "tellicoxmlexporter.h"
#include "../filehandler.h"

#include <tdelocale.h>
#include <kurlrequester.h>
#include <kuser.h>
#include <tdeconfig.h>

#include <tqlabel.h>
#include <tqgroupbox.h>
#include <tqlayout.h>
#include <tqhbox.h>
#include <tqdom.h>
#include <tqwhatsthis.h>

using Tellico::Export::XSLTExporter;

XSLTExporter::XSLTExporter() : Export::Exporter(),
    m_widget(0),
    m_URLRequester(0) {
}

TQString XSLTExporter::formatString() const {
  return i18n("XSLT");
}

TQString XSLTExporter::fileFilter() const {
  return i18n("*|All Files");
}


bool XSLTExporter::exec() {
  KURL u = m_URLRequester->url();
  if(u.isEmpty() || !u.isValid()) {
    return false;
  }
  //  XSLTHandler handler(FileHandler::readXMLFile(url));
  XSLTHandler handler(u);
  handler.addStringParam("date", TQDate::currentDate().toString(TQt::ISODate).latin1());
  handler.addStringParam("time", TQTime::currentTime().toString(TQt::ISODate).latin1());
  handler.addStringParam("user", KUser(KUser::UseRealUserID).loginName().latin1());

  TellicoXMLExporter exporter;
  exporter.setEntries(entries());
  exporter.setOptions(options());
  TQDomDocument dom = exporter.exportXML();
  return FileHandler::writeTextURL(url(), handler.applyStylesheet(dom.toString()),
                                   options() & ExportUTF8, options() & Export::ExportForce);
}

TQWidget* XSLTExporter::widget(TQWidget* parent_, const char* name_/*=0*/) {
  if(m_widget && TQT_BASE_OBJECT(m_widget->parent()) == TQT_BASE_OBJECT(parent_)) {
    return m_widget;
  }

  m_widget = new TQWidget(parent_, name_);
  TQVBoxLayout* l = new TQVBoxLayout(m_widget);

  TQGroupBox* group = new TQGroupBox(1, Qt::Horizontal, i18n("XSLT Options"), m_widget);
  l->addWidget(group);

  TQHBox* box = new TQHBox(group);
  box->setSpacing(4);
  (void) new TQLabel(i18n("XSLT file:"), box);
  m_URLRequester = new KURLRequester(box);
  TQWhatsThis::add(m_URLRequester, i18n("Choose the XSLT file used to transform the Tellico XML data."));

  TQString filter = i18n("*.xsl|XSL Files (*.xsl)") + TQChar('\n');
  filter += i18n("*|All Files");
  m_URLRequester->setFilter(filter);
  m_URLRequester->setMode(static_cast<KFile::Mode>(KFile::File | KFile::ExistingOnly));
  if(!m_xsltFile.isEmpty()) {
    m_URLRequester->setURL(m_xsltFile);
  }

  l->addStretch(1);
  return m_widget;
}

void XSLTExporter::readOptions(TDEConfig* config_) {
  TDEConfigGroup group(config_, TQString::fromLatin1("ExportOptions - %1").arg(formatString()));
  m_xsltFile = group.readEntry("Last File", TQString());
}

void XSLTExporter::saveOptions(TDEConfig* config_) {
  TDEConfigGroup group(config_, TQString::fromLatin1("ExportOptions - %1").arg(formatString()));
  m_xsltFile = m_URLRequester->url();
  group.writeEntry("Last File", m_xsltFile);
}
