/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004  Alexander Dymo <cloudtemple@mskat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "sizepolicyedit.h"
#include "editoritem.h"

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqsizepolicy.h>
#include <tqmap.h>
#include <tqtooltip.h>

#include <tdelocale.h>

using namespace KoProperty;

TQMap<TQString, TQVariant> *SizePolicyEdit::m_spValues = 0;

SizePolicyEdit::SizePolicyEdit(Property *property, TQWidget *parent, const char *name)
 : Widget(property, parent, name)
{
	setHasBorders(false);
//	TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
	m_edit = new TQLabel(this);
	m_edit->setIndent(KPROPEDITOR_ITEM_MARGIN);
	m_edit->setBackgroundMode(TQt::PaletteBase);
//	m_edit->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding);
	m_edit->setMinimumHeight(5);
	setEditor(m_edit);
//	l->addWidget(m_edit);
	setFocusWidget(m_edit);


	if(!m_spValues) {
		m_spValues = new TQMap<TQString, TQVariant>();
		(*m_spValues)[i18n("Size Policy", "Fixed")] = TQSizePolicy::Fixed;
		(*m_spValues)[i18n("Size Policy", "Minimum")] = TQSizePolicy::Minimum;
		(*m_spValues)[i18n("Size Policy", "Maximum")] = TQSizePolicy::Maximum;
		(*m_spValues)[i18n("Size Policy", "Preferred")] = TQSizePolicy::Preferred;
		(*m_spValues)[i18n("Size Policy", "Expanding")] = TQSizePolicy::Expanding;
		(*m_spValues)[i18n("Size Policy", "Minimum Expanding")] = TQSizePolicy::MinimumExpanding;
		(*m_spValues)[i18n("Size Policy", "Ignored")] = TQSizePolicy::Ignored;
	}
}

SizePolicyEdit::~SizePolicyEdit()
{
	delete m_spValues;
	m_spValues = 0;
}

TQVariant
SizePolicyEdit::value() const
{
	return m_value;
}

void
SizePolicyEdit::setValue(const TQVariant &value, bool emitChange)
{
	m_value = value;
	m_edit->setText(TQString("%1/%2/%3/%4").arg(findDescription(value.toSizePolicy().horData())).
		arg(findDescription(value.toSizePolicy().verData())).
		arg(value.toSizePolicy().horStretch()).arg(value.toSizePolicy().verStretch()));
	TQToolTip::add(this, m_edit->text());

	if (emitChange)
		emit valueChanged(this);
}

void
SizePolicyEdit::drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value)
{
//	p->eraseRect(r);
//	p->drawText(r, TQt::AlignLeft | TQt::AlignVCenter | TQt::SingleLine,
	TQRect rect(r);
	rect.setBottom(r.bottom()+1);
	Widget::drawViewer(p, cg, rect, 
		TQString("%1/%2/%3/%4").arg(findDescription(value.toSizePolicy().horData())).
		arg(findDescription(value.toSizePolicy().verData())).
		arg(value.toSizePolicy().horStretch()).arg(value.toSizePolicy().verStretch()));
}

TQString
SizePolicyEdit::findDescription(const TQVariant &value) const
{
	if(!m_spValues)
		return TQString();

	TQMap<TQString, TQVariant>::ConstIterator endIt = m_spValues->constEnd();
	for (TQMap<TQString, TQVariant>::ConstIterator it = m_spValues->constBegin(); it != endIt; ++ it) {
		if (it.data() == value)
			return it.key();
	}
	return TQString();;
}

void
SizePolicyEdit::setReadOnlyInternal(bool readOnly)
{
	Q_UNUSED(readOnly);
}

#include "sizepolicyedit.moc"
