/*
   This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __ko_koolbar_h__
#define __ko_koolbar_h__

#include <tqframe.h>
#include <tqpixmap.h>
#include <tqintdict.h>
#include <koffice_export.h>
class TQPushButton;
class TQPixmap;
class KoKoolBar;
class KoKoolBarGroup;

class KoKoolBarItem : public TQObject
{
private:
  Q_OBJECT
  
public:
  KoKoolBarItem( KoKoolBarGroup *_grp, const TQPixmap& _pix, const TQString& _text = TQString() );

  int id() const { return m_id; }
  void press();
  bool isEnabled() const { return m_bEnabled; }
  void setEnabled( bool _e ) { m_bEnabled = _e; }

  int height() const { return m_iHeight; }
  TQPixmap pixmap() const { return m_pixmap; }
  void setText( const TQString & text ) { m_strText = text; }
  TQString text() const { return m_strText; }

signals:
  void pressed( int _group, int _id );
  void pressed();
protected:
  void calc( TQWidget* );

  int m_iHeight;
  KoKoolBarGroup* m_pGroup;
  TQString m_strText;
  TQPixmap m_pixmap;
  int m_id;
  bool m_bEnabled;
  class KoKoolBarItemPrivate;
  KoKoolBarItemPrivate *d;
};

class KoKoolBarGroup : public TQObject
{
  Q_OBJECT
  
public:
  KoKoolBarGroup( KoKoolBar *_bar, const TQString& _text );
  ~KoKoolBarGroup();

  void append( KoKoolBarItem *_i ) { m_mapItems.insert( _i->id(), _i ); }
  void remove( int _id );

  KoKoolBar* bar() const { return m_pBar; }
  TQPushButton* button() const { return m_pButton; }
  int id() const { return m_id; }
  bool isEnabled() const { return m_bEnabled; }
  void setEnabled( bool _e ) { m_bEnabled = _e; }
  KoKoolBarItem* item( int _id ) const { return m_mapItems[ _id ]; }
  int items() const { return m_mapItems.size(); }
  TQIntDictIterator<KoKoolBarItem> iterator() const { return TQIntDictIterator<KoKoolBarItem>( m_mapItems ); }

public slots:
  void pressed();

protected:
  TQIntDict<KoKoolBarItem> m_mapItems;
  KoKoolBar* m_pBar;
  TQString m_strText;
  int m_id;
  TQPushButton* m_pButton;
  bool m_bEnabled;
  class KoKoolBarGroupPrivate;
  KoKoolBarGroupPrivate *d;
};

class KoKoolBarBox : public TQFrame
{
  Q_OBJECT
  
public:
  KoKoolBarBox( KoKoolBar *_bar );

  void setActiveGroup( KoKoolBarGroup *_grp );
  int maxHeight() const;

  void sizeChanged() { resizeEvent(0L); }

protected slots:
  void scrollUp();
  void scrollDown();

protected:
  virtual void resizeEvent( TQResizeEvent *_ev );
  virtual void drawContents( TQPainter * );
  virtual void mousePressEvent( TQMouseEvent *_ev )
  { KoKoolBarItem *item = findByPos( _ev->pos().y() + m_iYOffset ); if ( !item ) return; item->press(); }

  KoKoolBarItem* findByPos( int _abs_y ) const;

  bool needsScrolling() const;
  bool isAtBottom() const;
  bool isAtTop() const;
  void updateScrollButtons();

  KoKoolBar *m_pBar;
  int m_iYOffset;
  int m_iYIcon;
  KoKoolBarGroup *m_pGroup;
  TQPushButton* m_pButtonUp;
  TQPushButton* m_pButtonDown;
  class KoKoolBarBoxPrivate;
  KoKoolBarBoxPrivate *d;
};

class KOFFICEUI_EXPORT KoKoolBar : public TQWidget
{
  Q_OBJECT
  
public:
  KoKoolBar( TQWidget *_parent = 0L, const char *_name = 0L );
  virtual ~KoKoolBar() { };

  virtual int insertGroup( const TQString& _text );
  virtual int insertItem( int _grp, const TQPixmap& _pix, const TQString& _text = TQString(),
			  TQObject *_obj = 0L, const char *_slot = 0L );
  virtual void removeGroup( int _grp );
  virtual void removeItem( int _grp, int _id );
  virtual void renameItem( int _grp, int _id, const TQString & _text );
  virtual void setActiveGroup( int _grp );
  virtual int activeGroup() const { return m_iActiveGroup; }
  virtual void enableItem( int _grp, int _id, bool _enable );
  virtual void enableGroup( int _grp, bool _enable );

protected:
  virtual void resizeEvent( TQResizeEvent *_ev );

  TQIntDict<KoKoolBarGroup> m_mapGroups;

  int m_iActiveGroup;
  KoKoolBarBox* m_pBox;
  class KoKoolBarPrivate;
  KoKoolBarPrivate *d;
};

#endif
