/*
 *  Copyright (c) 2005 Adrian Page <adrian@pagenet.plus.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.g
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "kis_canvas.h"
#include "kis_canvas_painter.h"
#include "kis_qpaintdevice_canvas_painter.h"

KisCanvasWidgetPainter::KisCanvasWidgetPainter()
{
}

KisCanvasWidgetPainter::~KisCanvasWidgetPainter()
{
}

bool KisCanvasWidgetPainter::end()
{
    return true;
}

void KisCanvasWidgetPainter::save()
{
}

void KisCanvasWidgetPainter::restore()
{
}

TQFontMetrics KisCanvasWidgetPainter::fontMetrics() const
{
    return TQFontMetrics(TQFont());
}

TQFontInfo KisCanvasWidgetPainter::fontInfo() const
{
    return TQFontInfo(TQFont());
}

const TQFont& KisCanvasWidgetPainter::font() const
{
    return m_defaultFont;
}

void KisCanvasWidgetPainter::setFont(const TQFont& /*font*/)
{
}

const TQPen& KisCanvasWidgetPainter::pen() const
{
    return m_defaultPen;
}

void KisCanvasWidgetPainter::setPen(const TQPen& /*pen*/)
{
}

void KisCanvasWidgetPainter::setPen(Qt::PenStyle /*penStyle*/)
{
}

void KisCanvasWidgetPainter::setPen(const TQColor& /*color*/)
{
}

const TQBrush& KisCanvasWidgetPainter::brush() const
{
    return m_defaultBrush;
}

void KisCanvasWidgetPainter::setBrush(const TQBrush& /*brush*/)
{
}

void KisCanvasWidgetPainter::setBrush(TQt::BrushStyle /*brushStyle*/)
{
}

void KisCanvasWidgetPainter::setBrush(const TQColor& /*color*/)
{
}

TQPoint KisCanvasWidgetPainter::pos() const
{
    return TQPoint();
}

const TQColor& KisCanvasWidgetPainter::backgroundColor() const
{
    return m_defaultColor;
}

void KisCanvasWidgetPainter::setBackgroundColor(const TQColor& /*color*/)
{
}

Qt::BGMode KisCanvasWidgetPainter::backgroundMode() const
{
    return Qt::TransparentMode;
}

void KisCanvasWidgetPainter::setBackgroundMode(Qt::BGMode /*bgMode*/)
{
}

TQt::RasterOp KisCanvasWidgetPainter::rasterOp() const
{
    return TQt::CopyROP;
}

void KisCanvasWidgetPainter::setRasterOp(TQt::RasterOp /*rasterOp*/)
{
}

const TQPoint& KisCanvasWidgetPainter::brushOrigin() const
{
    return m_defaultBrushOrigin;
}

void KisCanvasWidgetPainter::setBrushOrigin(int /*x*/, int /*y*/)
{
}

void KisCanvasWidgetPainter::setBrushOrigin(const TQPoint& /*origin*/)
{
}

bool KisCanvasWidgetPainter::hasViewXForm() const
{
    return false;
}

bool KisCanvasWidgetPainter::hasWorldXForm() const
{
    return false;
}

void KisCanvasWidgetPainter::setViewXForm(bool /*enable*/)
{
}

TQRect KisCanvasWidgetPainter::window() const
{
    return TQRect();
}

void KisCanvasWidgetPainter::setWindow(const TQRect& /*r*/)
{
}

void KisCanvasWidgetPainter::setWindow(int /*x*/, int /*y*/, int /*w*/, int /*h*/)
{
}

TQRect KisCanvasWidgetPainter::viewport() const
{
    return TQRect();
}

void KisCanvasWidgetPainter::setViewport(const TQRect& /*r*/)
{
}

void KisCanvasWidgetPainter::setViewport(int /*x*/, int /*y*/, int /*w*/, int /*h*/)
{
}


void KisCanvasWidgetPainter::setWorldXForm(bool /*enable*/)
{
}

const TQWMatrix& KisCanvasWidgetPainter::worldMatrix() const
{
    return m_defaultWorldMatrix;
}

void KisCanvasWidgetPainter::setWorldMatrix(const TQWMatrix& /*matrix*/, bool /*combine*/)
{
}

void KisCanvasWidgetPainter::saveWorldMatrix()
{
}

void KisCanvasWidgetPainter::restoreWorldMatrix()
{
}

void KisCanvasWidgetPainter::scale(double /*sx*/, double /*sy*/)
{
}

void KisCanvasWidgetPainter::shear(double /*sh*/, double /*sv*/)
{
}

void KisCanvasWidgetPainter::rotate(double /*a*/)
{
}

void KisCanvasWidgetPainter::translate(double /*dx*/, double /*dy*/)
{
}

void KisCanvasWidgetPainter::resetXForm()
{
}

double KisCanvasWidgetPainter::translationX() const
{
    return 0;
}

double KisCanvasWidgetPainter::translationY() const
{
    return 0;
}

TQPoint KisCanvasWidgetPainter::xForm(const TQPoint& point) const
{
    return point;
}

TQRect KisCanvasWidgetPainter::xForm(const TQRect& r) const
{
    return r;
}

TQPointArray KisCanvasWidgetPainter::xForm(const TQPointArray& pointArray) const
{
    return pointArray;
}

TQPointArray KisCanvasWidgetPainter::xForm(const TQPointArray& pointArray, int /*index*/, int /*npoints*/) const
{
    return pointArray;
}

TQPoint KisCanvasWidgetPainter::xFormDev(const TQPoint& point) const
{
    return point;
}

TQRect KisCanvasWidgetPainter::xFormDev(const TQRect& r) const
{
    return r;
}

TQPointArray KisCanvasWidgetPainter::xFormDev(const TQPointArray& pointArray) const
{
    return pointArray;
}

TQPointArray KisCanvasWidgetPainter::xFormDev(const TQPointArray& pointArray, int /*index*/, int /*npoints*/) const
{
    return pointArray;
}

void KisCanvasWidgetPainter::setClipping(bool /*enable*/)
{
}

bool KisCanvasWidgetPainter::hasClipping() const
{
    return true;
}

TQRegion KisCanvasWidgetPainter::clipRegion(TQPainter::CoordinateMode /*mode*/) const
{
    return TQRegion();
}

void KisCanvasWidgetPainter::setClipRect(const TQRect& /*r*/, TQPainter::CoordinateMode /*mode*/)
{
}

void KisCanvasWidgetPainter::setClipRect(int /*x*/, int /*y*/, int /*w*/, int /*h*/, TQPainter::CoordinateMode /*mode*/)
{
}

void KisCanvasWidgetPainter::setClipRegion(const TQRegion& /*rgn*/, TQPainter::CoordinateMode /*mode*/)
{
}

void KisCanvasWidgetPainter::drawPoint(int /*x*/, int /*y*/)
{
}

void KisCanvasWidgetPainter::drawPoint(const TQPoint& /*point*/)
{
}

void KisCanvasWidgetPainter::drawPoints(const TQPointArray& /*pointArray*/, int /*index*/, int /*npoints*/)
{
}

void KisCanvasWidgetPainter::moveTo(int /*x*/, int /*y*/)
{
}

void KisCanvasWidgetPainter::moveTo(const TQPoint& /*point*/)
{
}

void KisCanvasWidgetPainter::lineTo(int /*x*/, int /*y*/)
{
}

void KisCanvasWidgetPainter::lineTo(const TQPoint& /*point*/)
{
}

void KisCanvasWidgetPainter::drawLine(int /*x1*/, int /*y1*/, int /*x2*/, int /*y2*/)
{
}

void KisCanvasWidgetPainter::drawLine(const TQPoint& /*start*/, const TQPoint& /*end*/)
{
}

void KisCanvasWidgetPainter::drawRect(int /*x*/, int /*y*/, int /*w*/, int /*h*/)
{
}

void KisCanvasWidgetPainter::drawRect(const TQRect& /*r*/)
{
}

void KisCanvasWidgetPainter::drawWinFocusRect(int /*x*/, int /*y*/, int /*w*/, int /*h*/)
{
}

void KisCanvasWidgetPainter::drawWinFocusRect(int /*x*/, int /*y*/, int /*w*/, int /*h*/, const TQColor& /*bgColor*/)
{
}

void KisCanvasWidgetPainter::drawWinFocusRect(const TQRect& /*r*/)
{
}

void KisCanvasWidgetPainter::drawWinFocusRect(const TQRect& /*r*/, const TQColor& /*bgColor*/)
{
}

void KisCanvasWidgetPainter::drawRoundRect(int /*x*/, int /*y*/, int /*w*/, int /*h*/, int /*xRnd*/, int /*yRnd*/)
{
}

void KisCanvasWidgetPainter::drawRoundRect(const TQRect& /*r*/, int /*xRnd*/, int /*yRnd*/)
{
}

void KisCanvasWidgetPainter::drawEllipse(int /*x*/, int /*y*/, int /*w*/, int /*h*/)
{
}

void KisCanvasWidgetPainter::drawEllipse(const TQRect& /*r*/)
{
}

void KisCanvasWidgetPainter::drawArc(int /*x*/, int /*y*/, int /*w*/, int /*h*/, int /*a*/, int /*alen*/)
{
}

void KisCanvasWidgetPainter::drawArc(const TQRect& /*r*/, int /*a*/, int /*alen*/)
{
}

void KisCanvasWidgetPainter::drawPie(int /*x*/, int /*y*/, int /*w*/, int /*h*/, int /*a*/, int /*alen*/)
{
}

void KisCanvasWidgetPainter::drawPie(const TQRect& /*r*/, int /*a*/, int /*alen*/)
{
}

void KisCanvasWidgetPainter::drawChord(int /*x*/, int /*y*/, int /*w*/, int /*h*/, int /*a*/, int /*alen*/)
{
}

void KisCanvasWidgetPainter::drawChord(const TQRect& /*r*/, int /*a*/, int /*alen*/)
{
}

void KisCanvasWidgetPainter::drawLineSegments(const TQPointArray& /*pointArray*/, int /*index*/, int /*nlines*/)
{
}

void KisCanvasWidgetPainter::drawPolyline(const TQPointArray& /*pointArray*/, int /*index*/, int /*npoints*/)
{
}

void KisCanvasWidgetPainter::drawPolygon(const TQPointArray& /*pointArray*/, bool /*winding*/, int /*index*/, int /*npoints*/)
{
}

void KisCanvasWidgetPainter::drawConvexPolygon(const TQPointArray& /*pointArray*/, int /*index*/, int /*npoints*/)
{
}

void KisCanvasWidgetPainter::drawCubicBezier(const TQPointArray& /*pointArray*/, int /*index*/)
{
}

void KisCanvasWidgetPainter::drawPixmap(int /*x*/, int /*y*/, const TQPixmap& /*pixmap*/, int /*sx*/, int /*sy*/, int /*sw*/, int /*sh*/)
{
}

void KisCanvasWidgetPainter::drawPixmap(const TQPoint& /*point*/, const TQPixmap& /*pixmap*/, const TQRect& /*sr*/)
{
}

void KisCanvasWidgetPainter::drawPixmap(const TQPoint& /*point*/, const TQPixmap& /*pixmap*/)
{
}

void KisCanvasWidgetPainter::drawPixmap(const TQRect& /*r*/, const TQPixmap& /*pixmap*/)
{
}

void KisCanvasWidgetPainter::drawImage(int /*x*/, int /*y*/, const TQImage& /*image*/, int /*sx*/, int /*sy*/, int /*sw*/, int /*sh*/, int /*conversionFlags*/)
{
}

void KisCanvasWidgetPainter::drawImage(const TQPoint& /*point*/, const TQImage& /*image*/, const TQRect& /*sr*/, int /*conversionFlags*/)
{
}

void KisCanvasWidgetPainter::drawImage(const TQPoint& /*point*/, const TQImage& /*image*/, int /*conversion_flags*/)
{
}

void KisCanvasWidgetPainter::drawImage(const TQRect& /*r*/, const TQImage& /*image*/)
{
}

void KisCanvasWidgetPainter::drawTiledPixmap(int /*x*/, int /*y*/, int /*w*/, int /*h*/, const TQPixmap& /*pixmap*/, int /*sx*/, int /*sy*/)
{
}

void KisCanvasWidgetPainter::drawTiledPixmap(const TQRect& /*r*/, const TQPixmap& /*pixmap*/, const TQPoint& /*point*/)
{
}

void KisCanvasWidgetPainter::drawTiledPixmap(const TQRect& /*r*/, const TQPixmap& /*pixmap*/)
{
}

void KisCanvasWidgetPainter::fillRect(int /*x*/, int /*y*/, int /*w*/, int /*h*/, const TQBrush& /*brush*/)
{
}

void KisCanvasWidgetPainter::fillRect(const TQRect& /*r*/, const TQBrush& /*brush*/)
{
}

void KisCanvasWidgetPainter::eraseRect(int /*x*/, int /*y*/, int /*w*/, int /*h*/)
{
}

void KisCanvasWidgetPainter::eraseRect(const TQRect& /*r*/)
{
}

void KisCanvasWidgetPainter::drawText(int /*x*/, int /*y*/, const TQString& /*text*/, int /*len*/, TQPainter::TextDirection /*dir*/)
{
}

void KisCanvasWidgetPainter::drawText(const TQPoint& /*point*/, const TQString& /*text*/, int /*len*/, TQPainter::TextDirection /*dir*/)
{
}

void KisCanvasWidgetPainter::drawText(int /*x*/, int /*y*/, const TQString& /*text*/, int /*pos*/, int /*len*/, TQPainter::TextDirection /*dir*/)
{
}

void KisCanvasWidgetPainter::drawText(const TQPoint& /*point*/, const TQString& /*text*/, int /*pos*/, int /*len*/, TQPainter::TextDirection /*dir*/)
{
}

void KisCanvasWidgetPainter::drawText(int /*x*/, int /*y*/, int /*w*/, int /*h*/, int /*flags*/, const TQString& /*text*/, int /*len*/, TQRect */*br*/, TQTextParag **/*intern*/)
{
}

void KisCanvasWidgetPainter::drawText(const TQRect& /*r*/, int /*flags*/, const TQString& /*text*/, int /*len*/, TQRect */*br*/, TQTextParag **/*intern*/)
{
}

void KisCanvasWidgetPainter::drawTextItem(int /*x*/, int /*y*/, const TQTextItem& /*ti*/, int /*textflags*/)
{
}

void KisCanvasWidgetPainter::drawTextItem(const TQPoint& /*p*/, const TQTextItem& /*ti*/, int /*textflags*/)
{
}

TQRect KisCanvasWidgetPainter::boundingRect(int /*x*/, int /*y*/, int /*w*/, int /*h*/, int /*flags*/, const TQString& /*text*/, int /*len*/, TQTextParag **/*intern*/)
{
    return TQRect();
}

TQRect KisCanvasWidgetPainter::boundingRect(const TQRect& /*r*/, int /*flags*/, const TQString& /*text*/, int /*len*/, TQTextParag **/*intern*/)
{
    return TQRect();
}

int	KisCanvasWidgetPainter::tabStops() const
{
    return 0;
}

void KisCanvasWidgetPainter::setTabStops(int /*ts*/)
{
}

int	*KisCanvasWidgetPainter::tabArray() const
{
    return 0;
}

void KisCanvasWidgetPainter::setTabArray(int */*ts*/)
{
}

/*************************************************************************/

KisCanvasPainter::KisCanvasPainter()
{
    m_canvasWidgetPainter = 0;
}

KisCanvasPainter::KisCanvasPainter(KisCanvas *canvas)
{
    m_canvasWidgetPainter = canvas->createPainter();
}

KisCanvasPainter::KisCanvasPainter(const TQPaintDevice *paintDevice)
{
    m_canvasWidgetPainter = new KisTQPaintDeviceCanvasPainter(paintDevice);
}

KisCanvasPainter::~KisCanvasPainter()
{
    delete m_canvasWidgetPainter;
}

bool KisCanvasPainter::begin(KisCanvas *canvas, bool unclipped)
{
    delete m_canvasWidgetPainter;
    m_canvasWidgetPainter = canvas->createPainter();
    return m_canvasWidgetPainter->begin(canvas->canvasWidget(), unclipped);
}

bool KisCanvasPainter::begin(const TQPaintDevice *paintDevice, bool unclipped)
{
    delete m_canvasWidgetPainter;
    m_canvasWidgetPainter = new KisTQPaintDeviceCanvasPainter();
    return static_cast<KisTQPaintDeviceCanvasPainter *>(m_canvasWidgetPainter)->begin(paintDevice, unclipped);
}

bool KisCanvasPainter::end()
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->end();
    }
    return false;
}

void KisCanvasPainter::save()
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->save();
    }
}

void KisCanvasPainter::restore()
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->restore();
    }
}

TQFontMetrics KisCanvasPainter::fontMetrics() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->fontMetrics();
    }
    return TQFontMetrics(TQFont());
}

TQFontInfo KisCanvasPainter::fontInfo() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->fontInfo();
    }
    return TQFontInfo(TQFont());
}

const TQFont& KisCanvasPainter::font() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->font();
    }
    return m_defaultFont;
}

void KisCanvasPainter::setFont(const TQFont& font)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setFont(font);
    }
}

const TQPen& KisCanvasPainter::pen() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->pen();
    }
    return m_defaultPen;
}

void KisCanvasPainter::setPen(const TQPen& pen)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setPen(pen);
    }
}

void KisCanvasPainter::setPen(Qt::PenStyle penStyle)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setPen(penStyle);
    }
}

void KisCanvasPainter::setPen(const TQColor& color)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setPen(color);;
    }
}

const TQBrush& KisCanvasPainter::brush() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->brush();
    }
    return m_defaultBrush;
}

void KisCanvasPainter::setBrush(const TQBrush& brush)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setBrush(brush);
    }
}

void KisCanvasPainter::setBrush(TQt::BrushStyle brushStyle)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setBrush(brushStyle);
    }
}

void KisCanvasPainter::setBrush(const TQColor& color)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setBrush(color);
    }
}

TQPoint KisCanvasPainter::pos() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->pos();
    }
    return TQPoint();
}

const TQColor& KisCanvasPainter::backgroundColor() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->backgroundColor();
    }
    return m_defaultColor;
}

void KisCanvasPainter::setBackgroundColor(const TQColor& color)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setBackgroundColor(color);
    }
}

Qt::BGMode KisCanvasPainter::backgroundMode() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->backgroundMode();
    }
    return Qt::TransparentMode;
}

void KisCanvasPainter::setBackgroundMode(Qt::BGMode bgMode)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setBackgroundMode(bgMode);
    }
}

TQt::RasterOp KisCanvasPainter::rasterOp() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->rasterOp();
    }
    return TQt::CopyROP;
}

void KisCanvasPainter::setRasterOp(TQt::RasterOp rasterOp)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setRasterOp(rasterOp);
    }
}

const TQPoint& KisCanvasPainter::brushOrigin() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->brushOrigin();
    }
    return m_defaultBrushOrigin;
}

void KisCanvasPainter::setBrushOrigin(int x, int y)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setBrushOrigin(x, y);
    }
}

void KisCanvasPainter::setBrushOrigin(const TQPoint& origin)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setBrushOrigin(origin);
    }
}

bool KisCanvasPainter::hasViewXForm() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->hasViewXForm();
    }
    return false;
}

bool KisCanvasPainter::hasWorldXForm() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->hasWorldXForm();
    }
    return false;
}

void KisCanvasPainter::setViewXForm(bool enable)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setViewXForm(enable);
    }
}

TQRect KisCanvasPainter::window() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->window();
    }
    return TQRect();
}

void KisCanvasPainter::setWindow(const TQRect& r)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setWindow(r);
    }
}

void KisCanvasPainter::setWindow(int x, int y, int w, int h)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setWindow(x, y, w, h);
    }
}

TQRect KisCanvasPainter::viewport() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->viewport();
    }
    return TQRect();
}

void KisCanvasPainter::setViewport(const TQRect& r)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setViewport(r);
    }
}

void KisCanvasPainter::setViewport(int x, int y, int w, int h)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setViewport(x, y, w, h);
    }
}

void KisCanvasPainter::setWorldXForm(bool enable)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setWorldXForm(enable);
    }
}

const TQWMatrix& KisCanvasPainter::worldMatrix() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->worldMatrix();
    }
    return m_defaultWorldMatrix;
}

void KisCanvasPainter::setWorldMatrix(const TQWMatrix& matrix, bool combine)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setWorldMatrix(matrix, combine);
    }
}

void KisCanvasPainter::saveWorldMatrix()
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->saveWorldMatrix();
    }
}

void KisCanvasPainter::restoreWorldMatrix()
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->restoreWorldMatrix();
    }
}

void KisCanvasPainter::scale(double sx, double sy)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->scale(sx, sy);
    }
}

void KisCanvasPainter::shear(double sh, double sv)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->shear(sh, sv);
    }
}

void KisCanvasPainter::rotate(double a)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->rotate(a);
    }
}

void KisCanvasPainter::translate(double dx, double dy)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->translate(dx, dy);
    }
}

void KisCanvasPainter::resetXForm()
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->resetXForm();
    }
}

double KisCanvasPainter::translationX() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->translationX();
    }
    return 0;
}

double KisCanvasPainter::translationY() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->translationY();
    }
    return 0;
}

TQPoint KisCanvasPainter::xForm(const TQPoint& point) const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->xForm(point);
    }
    return point;
}

TQRect KisCanvasPainter::xForm(const TQRect& r) const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->xForm(r);
    }
    return r;
}

TQPointArray KisCanvasPainter::xForm(const TQPointArray& pointArray) const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->xForm(pointArray);
    }
    return pointArray;
}

TQPointArray KisCanvasPainter::xForm(const TQPointArray& pointArray, int index, int npoints) const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->xForm(pointArray, index, npoints);
    }
    return pointArray;
}

TQPoint KisCanvasPainter::xFormDev(const TQPoint& point) const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->xFormDev(point);
    }
    return point;
}

TQRect KisCanvasPainter::xFormDev(const TQRect& r) const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->xFormDev(r);
    }
    return r;
}

TQPointArray KisCanvasPainter::xFormDev(const TQPointArray& pointArray) const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->xFormDev(pointArray);
    }
    return pointArray;
}

TQPointArray KisCanvasPainter::xFormDev(const TQPointArray& pointArray, int index, int npoints) const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->xFormDev(pointArray, index, npoints);
    }
    return pointArray;
}

void KisCanvasPainter::setClipping(bool enable)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setClipping(enable);
    }
}

bool KisCanvasPainter::hasClipping() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->hasClipping();
    }
    return true;
}

TQRegion KisCanvasPainter::clipRegion(TQPainter::CoordinateMode mode) const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->clipRegion(mode);
    }
    return TQRegion();
}

void KisCanvasPainter::setClipRect(const TQRect& r, TQPainter::CoordinateMode mode)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setClipRect(r, mode);
    }
}

void KisCanvasPainter::setClipRect(int x, int y, int w, int h, TQPainter::CoordinateMode mode)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setClipRect(x, y, w, h, mode);
    }
}

void KisCanvasPainter::setClipRegion(const TQRegion& rgn, TQPainter::CoordinateMode mode)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setClipRegion(rgn, mode);
    }
}

void KisCanvasPainter::drawPoint(int x, int y)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPoint(x, y);
    }
}

void KisCanvasPainter::drawPoint(const TQPoint& point)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPoint(point);
    }
}

void KisCanvasPainter::drawPoints(const TQPointArray& pointArray, int index, int npoints)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPoints(pointArray, index, npoints);
    }
}

void KisCanvasPainter::moveTo(int x, int y)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->moveTo(x, y);
    }
}

void KisCanvasPainter::moveTo(const TQPoint& point)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->moveTo(point);
    }
}

void KisCanvasPainter::lineTo(int x, int y)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->lineTo(x, y);
    }
}

void KisCanvasPainter::lineTo(const TQPoint& point)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->lineTo(point);
    }
}

void KisCanvasPainter::drawLine(int x1, int y1, int x2, int y2)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawLine(x1, y1, x2, y2);
    }
}

void KisCanvasPainter::drawLine(const TQPoint& start, const TQPoint& end)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawLine(start, end);
    }
}

void KisCanvasPainter::drawRect(int x, int y, int w, int h)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawRect(x, y, w, h);
    }
}

void KisCanvasPainter::drawRect(const TQRect& r)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawRect(r);
    }
}

void KisCanvasPainter::drawWinFocusRect(int x, int y, int w, int h)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawWinFocusRect(x, y, w, h);
    }
}

void KisCanvasPainter::drawWinFocusRect(int x, int y, int w, int h, const TQColor& bgColor)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawWinFocusRect(x, y, w, h, bgColor);
    }
}

void KisCanvasPainter::drawWinFocusRect(const TQRect& r)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawWinFocusRect(r);
    }
}

void KisCanvasPainter::drawWinFocusRect(const TQRect& r, const TQColor& bgColor)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawWinFocusRect(r, bgColor);
    }
}

void KisCanvasPainter::drawRoundRect(int x, int y, int w, int h, int xRnd, int yRnd)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawRoundRect(x, y, w, h, xRnd, yRnd);
    }
}

void KisCanvasPainter::drawRoundRect(const TQRect& r, int xRnd, int yRnd)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawRoundRect(r, xRnd, yRnd);
    }
}

void KisCanvasPainter::drawEllipse(int x, int y, int w, int h)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawEllipse(x, y, w, h);
    }
}

void KisCanvasPainter::drawEllipse(const TQRect& r)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawEllipse(r);
    }
}

void KisCanvasPainter::drawArc(int x, int y, int w, int h, int a, int alen)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawArc(x, y, w, h, a, alen);
    }
}

void KisCanvasPainter::drawArc(const TQRect& r, int a, int alen)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawArc(r, a, alen);
    }
}

void KisCanvasPainter::drawPie(int x, int y, int w, int h, int a, int alen)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPie(x, y, w, h, a, alen);
    }
}

void KisCanvasPainter::drawPie(const TQRect& r, int a, int alen)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPie(r, a, alen);
    }
}

void KisCanvasPainter::drawChord(int x, int y, int w, int h, int a, int alen)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawChord(x, y, w, h, a, alen);
    }
}

void KisCanvasPainter::drawChord(const TQRect& r, int a, int alen)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawChord(r, a, alen);
    }
}

void KisCanvasPainter::drawLineSegments(const TQPointArray& pointArray, int index, int nlines)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawLineSegments(pointArray, index, nlines);
    }
}

void KisCanvasPainter::drawPolyline(const TQPointArray& pointArray, int index, int npoints)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPolyline(pointArray, index, npoints);
    }
}

void KisCanvasPainter::drawPolygon(const TQPointArray& pointArray, bool winding, int index, int npoints)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPolygon(pointArray, winding, index, npoints);
    }
}

void KisCanvasPainter::drawConvexPolygon(const TQPointArray& pointArray, int index, int npoints)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawConvexPolygon(pointArray, index, npoints);
    }
}

void KisCanvasPainter::drawCubicBezier(const TQPointArray& pointArray, int index)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawCubicBezier(pointArray, index);
    }
}

void KisCanvasPainter::drawPixmap(int x, int y, const TQPixmap& pixmap, int sx, int sy, int sw, int sh)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPixmap(x, y, pixmap, sx, sy, sw, sh);
    }
}

void KisCanvasPainter::drawPixmap(const TQPoint& point, const TQPixmap& pixmap, const TQRect& sr)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPixmap(point, pixmap, sr);
    }
}

void KisCanvasPainter::drawPixmap(const TQPoint& point, const TQPixmap& pixmap)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPixmap(point, pixmap);
    }
}

void KisCanvasPainter::drawPixmap(const TQRect& r, const TQPixmap& pixmap)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawPixmap(r, pixmap);
    }
}

void KisCanvasPainter::drawImage(int x, int y, const TQImage& image, int sx, int sy, int sw, int sh, int conversionFlags)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawImage(x, y, image, sx, sy, sw, sh, conversionFlags);
    }
}

void KisCanvasPainter::drawImage(const TQPoint& point, const TQImage& image, const TQRect& sr, int conversionFlags)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawImage(point, image, sr, conversionFlags);
    }
}

void KisCanvasPainter::drawImage(const TQPoint& point, const TQImage& image, int conversion_flags)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawImage(point, image, conversion_flags);
    }
}

void KisCanvasPainter::drawImage(const TQRect& r, const TQImage& image)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawImage(r, image);
    }
}

void KisCanvasPainter::drawTiledPixmap(int x, int y, int w, int h, const TQPixmap& pixmap, int sx, int sy)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawTiledPixmap(x, y, w, h, pixmap, sx, sy);
    }
}

void KisCanvasPainter::drawTiledPixmap(const TQRect& r, const TQPixmap& pixmap, const TQPoint& point)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawTiledPixmap(r, pixmap, point);
    }
}

void KisCanvasPainter::drawTiledPixmap(const TQRect& r, const TQPixmap& pixmap)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawTiledPixmap(r, pixmap);
    }
}

void KisCanvasPainter::fillRect(int x, int y, int w, int h, const TQBrush& brush)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->fillRect(x, y, w, h, brush);
    }
}

void KisCanvasPainter::fillRect(const TQRect& r, const TQBrush& brush)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->fillRect(r, brush);
    }
}

void KisCanvasPainter::eraseRect(int x, int y, int w, int h)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->eraseRect(x, y, w, h);
    }
}

void KisCanvasPainter::eraseRect(const TQRect& r)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->eraseRect(r);
    }
}

void KisCanvasPainter::drawText(int x, int y, const TQString& text, int len, TQPainter::TextDirection dir)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawText(x, y, text, len, dir);
    }
}

void KisCanvasPainter::drawText(const TQPoint& point, const TQString& text, int len, TQPainter::TextDirection dir)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawText(point, text, len, dir);
    }
}

void KisCanvasPainter::drawText(int x, int y, const TQString& text, int pos, int len, TQPainter::TextDirection dir)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawText(x, y, text, pos, len, dir);
    }
}

void KisCanvasPainter::drawText(const TQPoint& point, const TQString& text, int pos, int len, TQPainter::TextDirection dir)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawText(point, text, pos, len, dir);
    }
}

void KisCanvasPainter::drawText(int x, int y, int w, int h, int flags, const TQString& text, int len, TQRect *br, TQTextParag **intern)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawText(x, y, w, h, flags, text, len, br, intern);
    }
}

void KisCanvasPainter::drawText(const TQRect& r, int flags, const TQString& text, int len, TQRect *br, TQTextParag **intern)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawText(r, flags, text, len, br, intern);
    }
}

void KisCanvasPainter::drawTextItem(int x, int y, const TQTextItem& ti, int textflags)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawTextItem(x, y, ti, textflags);
    }
}

void KisCanvasPainter::drawTextItem(const TQPoint& p, const TQTextItem& ti, int textflags)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->drawTextItem(p, ti, textflags);
    }
}

TQRect KisCanvasPainter::boundingRect(int x, int y, int w, int h, int flags, const TQString& text, int len, TQTextParag **intern)
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->boundingRect(x, y, w, h, flags, text, len, intern);
    }
    return TQRect();
}

TQRect KisCanvasPainter::boundingRect(const TQRect& r, int flags, const TQString& text, int len, TQTextParag **intern)
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->boundingRect(r, flags, text, len, intern);
    }
    return TQRect();
}

int	KisCanvasPainter::tabStops() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->tabStops();
    }
    return 0;
}

void KisCanvasPainter::setTabStops(int ts)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setTabStops(ts);
    }
}

int	*KisCanvasPainter::tabArray() const
{
    if (m_canvasWidgetPainter != 0) {
        return m_canvasWidgetPainter->tabArray();
    }
    return 0;
}

void KisCanvasPainter::setTabArray(int *ts)
{
    if (m_canvasWidgetPainter != 0) {
        m_canvasWidgetPainter->setTabArray(ts);
    }
}

