/***************************************************************************
                          kreportsview.h  -  description
                             -------------------
    begin                : Sat Mar 27 2004
    copyright            : (C) 2000-2004 by Michael Edwardes
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
                           Ace Jones <ace.jones@hotpop.com>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KREPORTSVIEW_H
#define KREPORTSVIEW_H

// Some STL headers in GCC4.3 contain operator new. Memory checker mangles these
#ifdef _CHECK_MEMORY
  #undef new
#endif

// ----------------------------------------------------------------------------
// QT Includes

#include <tqvaluevector.h>
#include <tqwidget.h>

class TQVBoxLayout;
class TQListViewItem;

// ----------------------------------------------------------------------------
// KDE Includes

#include <tdehtml_part.h>
#include <tdelistview.h>
#include <ktabwidget.h>

// ----------------------------------------------------------------------------
// Project Includes
#ifdef _CHECK_MEMORY
  #include <kmymoney/mymoneyutils.h>
#endif

#include <kmymoney/mymoneyscheduled.h>
#include <kmymoney/mymoneyaccount.h>
#include <kmymoney/mymoneyreport.h>
#include "../reports/pivottable.h"
#include "../reports/querytable.h"
#include "../widgets/kmymoneyreportcontroldecl.h"
#include "../reports/kreportchartview.h"
#include "../views/kmymoneyview.h"

class MyMoneyReport;

namespace KReportView {
};


/**
  * Displays a page where reports can be placed.
  *
  * @author Ace Jones
  *
  * @short A view for reports.
**/
class KReportsView : public KMyMoneyViewBase
{
  Q_OBJECT
  
public:

  /**
    * Helper class for KReportView.
    *
    * This is the widget which displays a single report in the TabWidget that comprises this view.
    *
    * @author Ace Jones
    */

  class KReportTab: public TQWidget
  {
  private:
    TDEHTMLPart* m_part;
    reports::KReportChartView* m_chartView;
    kMyMoneyReportControlDecl* m_control;
    TQVBoxLayout* m_layout;
    MyMoneyReport m_report;
    bool m_deleteMe;
    bool m_showingChart;
    bool m_needReload;
    reports::ReportTable* m_table;

  public:
    KReportTab(KTabWidget* parent, const MyMoneyReport& report );
    ~KReportTab();
    const MyMoneyReport& report(void) const { return m_report; }
    void print(void);
    void toggleChart(void);
    void copyToClipboard(void);
    void saveAs( const TQString& filename, bool includeCSS = false );
    void updateReport(void);
    TQString createTable(const TQString& links=TQString());
    const kMyMoneyReportControlDecl* control(void) const { return m_control; }
    bool isReadyToDelete(void) const { return m_deleteMe; }
    void setReadyToDelete(bool f) { m_deleteMe = f; }
    void modifyReport( const MyMoneyReport& report ) { m_report = report; }
    void show(void);
    void loadTab(void);
  };

  /**
    * Helper class for KReportView.
    *
    * Associates a report id with a list view item.
    *
    * @author Ace Jones
    */

  class KReportListItem: public TDEListViewItem
  {
  private:
    TQString m_id;
    MyMoneyReport m_report;

  public:
    KReportListItem( TDEListView* parent, const MyMoneyReport& report ):
      TDEListViewItem( parent, report.name(), report.comment() ),
      m_id( report.id() ),
      m_report( report )
    {}
    KReportListItem( TDEListViewItem* parent, const MyMoneyReport& report ):
      TDEListViewItem( parent, report.name(), report.comment() ),
      m_id( report.id() ),
      m_report( report )
    {}
    //const TQString& id(void) const { return m_id; }
    const MyMoneyReport& report(void) const { return m_report; }
  };

  class KReportGroupListItem: public TDEListViewItem
  {
  private:
    int m_nr;
    TQString m_name;

  public:
    KReportGroupListItem( TDEListView* parent,const int nr,const TQString name);
    virtual TQString key ( int column, bool ascending ) const;
    void setNr(const int nr);
  };

  /**
    * Helper class for KReportView.
    *
    * This is a named list of reports, which will be one section
    * in the list of default reports
    *
    * @author Ace Jones
    */
  class ReportGroup: public TQValueList<MyMoneyReport>
  {
  private:
    TQString m_name;     ///< the title of the group in non-translated form
    TQString m_title;    ///< the title of the group in i18n-ed form
  public:
    ReportGroup( void ) {}
    ReportGroup( const TQString& name, const TQString& title ): m_name( name ), m_title(title) {}
    const TQString& name( void ) const { return m_name; }
    const TQString& title(void) const { return m_title; }
  };

private:
  /// \internal d-pointer class.
  class Private;
  /// \internal d-pointer instance.
  Private* const d;
  KTabWidget* m_reportTabWidget;
  TDEListView* m_reportListView;
  TQWidget* m_listTab;
  TQVBoxLayout* m_listTabLayout;
  bool m_needReload;

public:
  /**
    * Standard constructor.
    *
    * @param parent The TQWidget this is used in.
    * @param name The QT name.
    *
    * @return An object of type KReportsView
    *
    * @see ~KReportsView
    */
  KReportsView(TQWidget *parent=0, const char *name=0);

  /**
    * Standard destructor.
    *
    * @return Nothing.
    *
    * @see KReportsView
    */
  ~KReportsView();

  /**
    * Overridden so we can reload the view if necessary.
    *
    * @return Nothing.
    */
  void show();

protected:
  void addReportTab(const MyMoneyReport&);
  void loadView(void);
  static void defaultReports(TQValueList<ReportGroup>&);

public slots:
  void slotOpenURL(const KURL &url, const KParts::URLArgs& args);

  void slotLoadView(void);
  void slotPrintView(void);
  void slotCopyView(void);
  void slotSaveView(void);
  void slotConfigure(void);
  void slotDuplicate(void);
  void slotToggleChart(void);
  void slotOpenReport(TQListViewItem*);
  void slotOpenReport(const TQString&);
  void slotOpenReport(const MyMoneyReport&);
  void slotCloseCurrent(void);
  void slotClose(TQWidget*);
  void slotCloseAll(void);
  void slotDelete(void);
  void slotListContextMenu(TDEListView*,TQListViewItem*,const TQPoint &);
  void slotOpenFromList(void);
  void slotConfigureFromList(void);
  void slotNewFromList(void);
  void slotDeleteFromList(void);

protected slots:
  void slotSaveFilterChanged(const TQString&);

signals:
  /**
    * This signal is emitted whenever a report is selected
    */
  void reportSelected(const MyMoneyReport&);


};

#endif
