/***************************************************************************
                          tdeselecttransactionsdlg.cpp
                             -------------------
    begin                : Wed May 16 2007
    copyright            : (C) 2007 by Thomas Baumgart
    email                : ipwizard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// KDE Includes

#include <kpushbutton.h>
#include <kstdguiitem.h>
#include <tdeapplication.h>
#include <kactivelabel.h>
#include <tdelocale.h>

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/mymoneyfile.h>
#include <kmymoney/mymoneytransaction.h>
#include <kmymoney/kmymoneyglobalsettings.h>

#include "kmergetransactionsdlg.h"

TDESelectTransactionsDlg::TDESelectTransactionsDlg(const MyMoneyAccount& _account, TQWidget* parent, const char* name) :
  TDESelectTransactionsDlgDecl(parent, name),
  m_account(_account)
{
  // setup descriptive texts
  setCaption(i18n("Select Transaction"));
  m_description->setText(i18n("Select a transaction and press the OK button or use Cancel to select none."));

  // clear current register contents
  m_register->clear();

  // no selection possible
  m_register->setSelectionMode(TQTable::Single);

  // setup header font
  TQFont font = KMyMoneyGlobalSettings::listHeaderFont();
  TQFontMetrics fm( font );
  int height = fm.lineSpacing()+6;
  m_register->horizontalHeader()->setMinimumHeight(height);
  m_register->horizontalHeader()->setMaximumHeight(height);
  m_register->horizontalHeader()->setFont(font);

  // setup cell font
  font = KMyMoneyGlobalSettings::listCellFont();
  m_register->setFont(font);

  // ... setup the register columns ...
  m_register->setupRegister(m_account);

  // setup buttons
  m_helpButton->setGuiItem(KStdGuiItem::help());
  buttonOk->setGuiItem(KStdGuiItem::ok());
  buttonCancel->setGuiItem(KStdGuiItem::cancel());

  // default is to need at least one transaction selected
  buttonOk->setDisabled(true);

  // catch some events from the register
  m_register->installEventFilter(this);

  connect(m_register, TQT_SIGNAL(selectionChanged(const KMyMoneyRegister::SelectedTransactions&)), this, TQT_SLOT(slotEnableOk(const KMyMoneyRegister::SelectedTransactions&)));
  connect(m_register, TQT_SIGNAL(editTransaction()), this, TQT_SLOT(accept()));

  connect(m_helpButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotHelp()));
}

void TDESelectTransactionsDlg::slotEnableOk(const KMyMoneyRegister::SelectedTransactions& list)
{
  buttonOk->setEnabled(list.count() != 0);
}

void TDESelectTransactionsDlg::addTransaction(const MyMoneyTransaction& t)
{
  TQValueList<MyMoneySplit>::const_iterator it_s;
  for(it_s = t.splits().begin(); it_s != t.splits().end(); ++it_s) {
    if((*it_s).accountId() == m_account.id()) {
      KMyMoneyRegister::Transaction* tr = KMyMoneyRegister::Register::transactionFactory(m_register, t, (*it_s), 0);
      // force full detail display
      tr->setNumRowsRegister(tr->numRowsRegister(true));
      break;
    }
  }
}

int TDESelectTransactionsDlg::exec(void)
{
  m_register->updateRegister(true);
  m_register->updateContents();

  m_register->setFocus();

  return TDESelectTransactionsDlgDecl::exec();
}

void TDESelectTransactionsDlg::slotHelp(void)
{
  // kapp->invokeHelp("details.ledgers.match");
}

void TDESelectTransactionsDlg::show(void)
{
  TDESelectTransactionsDlgDecl::show();
  m_register->resize(KMyMoneyRegister::DetailColumn);
}

void TDESelectTransactionsDlg::resizeEvent(TQResizeEvent* ev)
{
  // don't forget the resizer
  TDESelectTransactionsDlgDecl::resizeEvent(ev);

  // resize the register
  m_register->resize(KMyMoneyRegister::DetailColumn);
}

MyMoneyTransaction TDESelectTransactionsDlg::transaction(void) const
{
  MyMoneyTransaction t;

  TQValueList<KMyMoneyRegister::RegisterItem*> list;
  list = m_register->selectedItems();
  if(list.count()) {
    KMyMoneyRegister::Transaction* _t = dynamic_cast<KMyMoneyRegister::Transaction*>(list[0]);
    if(_t)
      t = _t->transaction();
  }
  return t;
}

bool TDESelectTransactionsDlg::eventFilter(TQObject* o, TQEvent* e)
{
  bool rc = false;
  TQKeyEvent* k;

  if(TQT_BASE_OBJECT(o) == TQT_BASE_OBJECT(m_register)) {
    switch(e->type()) {
      case TQEvent::KeyPress:
        k = dynamic_cast<TQKeyEvent*>(e);
        if((k->state() & TQt::KeyButtonMask) == 0) {
          switch(k->key()) {
            case TQt::Key_Return:
            case TQt::Key_Enter:
              if(buttonOk->isEnabled()) {
                accept();
                rc = true;
              }
              // tricky fall through here
            default:
              break;
          }
        }
        // tricky fall through here
      default:
        break;
    }
  }
  return rc;
}

#include "tdeselecttransactionsdlg.moc"
