#if 0

// Note: this file has been copied from the TQt source.
// Those classes are normally used internally in TQt
// but we need them for immitate the roll-over effect of TQComboBox.
//
// A portion of code has been added. It's underlined by "THIS CODE WAS ADDED:".
//
// And some class definitions have been moved from this file to qeffects.h
// Theire old position is indicated by "REMOVED CLASS DEFINITION HERE (MOVED TO qeffects.h)"

/****************************************************************************
** $Id: qt/qeffects.cpp   3.3.4   edited Dec 10 10:13 $
**
** Implementation of TQEffects functions
**
** Created : 000621
**
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the TQt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.TQPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for TQPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "tqapplication.h"
#ifndef TQT_NO_EFFECTS
#include "tqwidget.h"
#include "tqeffects.h"
#include "tqpixmap.h"
#include "tqimage.h"
#include "tqtimer.h"
#include "tqdatetime.h"
#include "tqguardedptr.h"
#include "tqscrollview.h"

/* REMOVED CLASS DEFINITION HERE (MOVED TO qeffects.h) */

static TQAlphaWidget* q_blend = 0;

/*
  Constructs a TQAlphaWidget.
*/
TQAlphaWidget::TQAlphaWidget( TQWidget* w, WFlags f )
	: TQWidget( TQApplication::desktop()->screen(TQApplication::desktop()->screenNumber(w)),
			   "qt internal alpha effect widget", f )
{
#if 1 //ndef TQ_WS_WIN
    setEnabled( FALSE );
#endif

    pm.setOptimization( TQPixmap::BestOptim );
    setBackgroundMode( NoBackground );
	widget = (TQAccessWidget*)w;
	alpha = 0;
}

/*
  \reimp
*/
void TQAlphaWidget::paintEvent( TQPaintEvent* )
{
	bitBlt( this, TQPoint(0,0), &pm );
}

/*
  Starts the alphablending animation.
  The animation will take about \a time ms
*/
void TQAlphaWidget::run( int time )
{
	duration = time;

	if ( duration < 0 )
		duration = 150;

	if ( !widget )
		return;

	elapsed = 0;
	checkTime.start();

	showWidget = TRUE;
	tqApp->installEventFilter( this );

	widget->setWState( WState_Visible );

	move( widget->geometry().x(),widget->geometry().y() );
	resize( widget->size().width(), widget->size().height() );

	front = TQImage( widget->size(), 32 );
	front = TQPixmap::grabWidget( widget );

	back = TQImage( widget->size(), 32 );
	back = TQPixmap::grabWindow( TQApplication::desktop()->winId(),
								widget->geometry().x(), widget->geometry().y(),
								widget->geometry().width(), widget->geometry().height() );

	if ( !back.isNull() && checkTime.elapsed() < duration / 2 ) {
		mixed = back.copy();
		pm = mixed;
		show();
		setEnabled(FALSE);

		connect( &anim, TQT_SIGNAL(timeout()), this, TQT_SLOT(render()));
		anim.start( 1 );
	} else {
		duration = 0;
		render();
	}
}

/*
  \reimp
*/
bool TQAlphaWidget::eventFilter( TQObject* o, TQEvent* e )
{
	switch ( e->type() ) {
		case TQEvent::Move:
			if ( o != widget )
				break;
			move( widget->geometry().x(),widget->geometry().y() );
			update();
			break;
		case TQEvent::Hide:
		case TQEvent::Close:
			if ( o != widget )
				break;
		case TQEvent::MouseButtonPress:
#ifndef TQT_NO_SCROLLVIEW
	if ( ::tqqt_cast<TQScrollView*>(o) )
	    break;
#endif
		case TQEvent::MouseButtonDblClick:
			setEnabled(TRUE);
			showWidget = FALSE;
			render();
			break;
		case TQEvent::KeyPress:
		{
			TQKeyEvent *ke = (TQKeyEvent*)e;
			if ( ke->key() == Key_Escape )
				showWidget = FALSE;
			else
				duration = 0;
			render();
			break;
		}
		default:
			break;
	}
	return TQWidget::eventFilter( o, e );
}

/*
  \reimp
*/
void TQAlphaWidget::closeEvent( TQCloseEvent *e )
{
	e->accept();
	if ( !q_blend )
		return;

	showWidget = FALSE;
	render();

	TQWidget::closeEvent( e );
}

/*
  Render alphablending for the time elapsed.

  Show the blended widget and free all allocated source
  if the blending is finished.
*/
void TQAlphaWidget::render()
{
	int tempel = checkTime.elapsed();
	if ( elapsed >= tempel )
		elapsed++;
	else
		elapsed = tempel;

	if ( duration != 0 )
		alpha = tempel / double(duration);
	else
		alpha = 1;
	if ( alpha >= 1 || !showWidget) {
		anim.stop();
		tqApp->removeEventFilter( this );

		if ( widget ) {
			if ( !showWidget ) {
#ifdef TQ_WS_WIN
                setEnabled(TRUE);
                setFocus();
#endif
		widget->hide();
		widget->setWState( WState_ForceHide );
		widget->clearWState( WState_Visible );
			} else if ( duration ) {
				BackgroundMode bgm = widget->backgroundMode();
				TQColor erc = widget->eraseColor();
				const TQPixmap *erp = widget->erasePixmap();

				widget->clearWState( WState_Visible );
				widget->setBackgroundMode( NoBackground );
				widget->show();
				if ( bgm != FixedColor && bgm != FixedPixmap ) {
					widget->clearWState( WState_Visible ); // prevent update in setBackgroundMode
					widget->setBackgroundMode( bgm );
					widget->setWState( WState_Visible );
				}
				if ( erc.isValid() ) {
					widget->setEraseColor( erc );
				} else if ( erp ) {
					widget->setErasePixmap( *erp );
				}
			} else {
				widget->clearWState( WState_Visible );
				widget->show();
			}
		}
		q_blend = 0;
		deleteLater();
	} else {
		if (widget)
			widget->clearWState( WState_ForceHide );
		alphaBlend();
		pm = mixed;
		repaint( FALSE );
	}
}

/*
  Calculate an alphablended image.
*/
void TQAlphaWidget::alphaBlend()
{
	const double ia = 1-alpha;
	const int sw = front.width();
	const int sh = front.height();
	switch( front.depth() ) {
		case 32:
		{
			TQ_UINT32** md = (TQ_UINT32**)mixed.jumpTable();
			TQ_UINT32** bd = (TQ_UINT32**)back.jumpTable();
			TQ_UINT32** fd = (TQ_UINT32**)front.jumpTable();

			for (int sy = 0; sy < sh; sy++ ) {
				TQ_UINT32* bl = ((TQ_UINT32*)bd[sy]);
				TQ_UINT32* fl = ((TQ_UINT32*)fd[sy]);
				for (int sx = 0; sx < sw; sx++ ) {
					TQ_UINT32 bp = bl[sx];
					TQ_UINT32 fp = fl[sx];

					((TQ_UINT32*)(md[sy]))[sx] =  tqRgb(int (tqRed(bp)*ia + tqRed(fp)*alpha),
					int (tqGreen(bp)*ia + tqGreen(fp)*alpha),
					int (tqBlue(bp)*ia + tqBlue(fp)*alpha) );
				}
			}
		}
		default:
			break;
	}
}

/* REMOVED CLASS DEFINITION HERE (MOVED TO qeffects.h) */

static TQRollEffect* q_roll = 0;

/*
  Construct a TQRollEffect widget.
*/
TQRollEffect::TQRollEffect( TQWidget* w, WFlags f, DirFlags orient )
	: TQWidget( TQApplication::desktop()->screen(TQApplication::desktop()->screenNumber(w)),
			   "qt internal roll effect widget", f ), orientation(orient)
{
#if 1 //ndef TQ_WS_WIN
    setEnabled( FALSE );
#endif
    widget = (TQAccessWidget*) w;
    Q_ASSERT( widget );

	setBackgroundMode( NoBackground );

	if ( widget->testWState( WState_Resized ) ) {
		totalWidth = widget->width();
		totalHeight = widget->height();
	} else {
		totalWidth = widget->sizeHint().width();
		totalHeight = widget->sizeHint().height();
	}

	currentHeight = totalHeight;
	currentWidth = totalWidth;

	if ( orientation & (RightScroll|LeftScroll) )
		currentWidth = 0;
	if ( orientation & (DownScroll|UpScroll) )
		currentHeight = 0;

	pm.setOptimization( TQPixmap::BestOptim );
	pm = TQPixmap::grabWidget( widget );
}

/*
  \reimp
*/
void TQRollEffect::paintEvent( TQPaintEvent* )
{
	int x = orientation & RightScroll ? TQMIN(0, currentWidth - totalWidth) : 0;
	int y = orientation & DownScroll ? TQMIN(0, currentHeight - totalHeight) : 0;

	bitBlt( this, x, y, &pm,
			0, 0, pm.width(), pm.height(), CopyROP, TRUE );
}

/*
  \reimp
*/
bool TQRollEffect::eventFilter( TQObject* o, TQEvent* e )
{
	switch ( e->type() ) {
		case TQEvent::Move:
			if ( o != widget )
				break;
			move( widget->geometry().x(),widget->geometry().y() );
			update();
			break;
		case TQEvent::Hide:
		case TQEvent::Close:
			if ( o != widget || done )
				break;
			setEnabled(TRUE);
			showWidget = FALSE;
			done = TRUE;
			scroll();
			break;
		case TQEvent::MouseButtonPress:
#ifndef TQT_NO_SCROLLVIEW
	if ( ::tqqt_cast<TQScrollView*>(o) )
	    break;
#endif
		case TQEvent::MouseButtonDblClick:
			if ( done )
				break;
			setEnabled(TRUE);
			showWidget = FALSE;
			done = TRUE;
			scroll();
			break;
		case TQEvent::KeyPress:
		{
			TQKeyEvent *ke = (TQKeyEvent*)e;


			/* THIS CODE WAS ADDED: **************                                                           */
			if (ke->key() == TQt::Key_Enter)   /*** Because we are simulating an Enter key press.             */
				break;                        /*** So we should not car about it and continue the animation. */
			/*************************************                                                           */


			if ( ke->key() == Key_Escape )
				showWidget = FALSE;
			done = TRUE;
			scroll();
			break;
		}
		default:
			break;
	}
	return TQWidget::eventFilter( o, e );
}

/*
  \reimp
*/
void TQRollEffect::closeEvent( TQCloseEvent *e )
{
	e->accept();
	if ( done )
		return;
	showWidget = FALSE;
	done = TRUE;
	scroll();

	TQWidget::closeEvent( e );
}

/*
  Start the animation.

  The animation will take about \a time ms, or is
  calculated if \a time is negative
*/
void TQRollEffect::run( int time )
{
	if ( !widget )
		return;

	duration  = time;
	elapsed = 0;

	if ( duration < 0 ) {
		int dist = 0;
		if ( orientation & (RightScroll|LeftScroll) )
			dist += totalWidth - currentWidth;
		if ( orientation & (DownScroll|UpScroll) )
			dist += totalHeight - currentHeight;
		duration = TQMIN( TQMAX( dist/3, 50 ), 120 );
	}

	connect( &anim, TQT_SIGNAL(timeout()), this, TQT_SLOT(scroll()));

	widget->setWState( WState_Visible );

	move( widget->geometry().x(),widget->geometry().y() );
	resize( TQMIN( currentWidth, totalWidth ), TQMIN( currentHeight, totalHeight ) );

	show();
	setEnabled(FALSE);

	tqApp->installEventFilter( this );

	showWidget = TRUE;
	done = FALSE;
	anim.start( 1 );
	checkTime.start();
}

/*
  Roll according to the time elapsed.
*/
void TQRollEffect::scroll()
{
	if ( !done && widget) {
		widget->clearWState( WState_ForceHide );
		int tempel = checkTime.elapsed();
		if ( elapsed >= tempel )
			elapsed++;
		else
			elapsed = tempel;

		if ( currentWidth != totalWidth ) {
			currentWidth = totalWidth * (elapsed/duration)
					+ ( 2 * totalWidth * (elapsed%duration) + duration )
		/ ( 2 * duration );
	    // equiv. to int( (totalWidth*elapsed) / duration + 0.5 )
			done = (currentWidth >= totalWidth);
		}
		if ( currentHeight != totalHeight ) {
			currentHeight = totalHeight * (elapsed/duration)
					+ ( 2 * totalHeight * (elapsed%duration) + duration )
		/ ( 2 * duration );
	    // equiv. to int( (totalHeight*elapsed) / duration + 0.5 )
			done = (currentHeight >= totalHeight);
		}
		done = ( currentHeight >= totalHeight ) &&
					( currentWidth >= totalWidth );

		int w = totalWidth;
		int h = totalHeight;
		int x = widget->geometry().x();
		int y = widget->geometry().y();

		if ( orientation & RightScroll || orientation & LeftScroll )
			w = TQMIN( currentWidth, totalWidth );
		if ( orientation & DownScroll || orientation & UpScroll )
			h = TQMIN( currentHeight, totalHeight );

		setUpdatesEnabled( FALSE );
		if ( orientation & UpScroll )
			y = widget->geometry().y() + TQMAX( 0, totalHeight - currentHeight );
		if ( orientation & LeftScroll )
			x = widget->geometry().x() + TQMAX( 0, totalWidth - currentWidth );
		if ( orientation & UpScroll || orientation & LeftScroll )
			move( x, y );

		resize( w, h );
		setUpdatesEnabled( TRUE );
		repaint( FALSE );
	}
	if ( done ) {
		anim.stop();
		tqApp->removeEventFilter( this );
		if ( widget ) {
			if ( !showWidget ) {
#ifdef TQ_WS_WIN
                setEnabled(TRUE);
                setFocus();
#endif
		widget->hide();
		widget->setWState( WState_ForceHide );
		widget->clearWState( WState_Visible );
			} else {
				BackgroundMode bgm = widget->backgroundMode();
				TQColor erc = widget->eraseColor();
				const TQPixmap *erp = widget->erasePixmap();

				widget->clearWState( WState_Visible );
				widget->setBackgroundMode( NoBackground );
				widget->show();
				if ( bgm != FixedColor && bgm != FixedPixmap ) {
					widget->clearWState( WState_Visible ); // prevent update in setBackgroundMode
					widget->setBackgroundMode( bgm );
					widget->setWState( WState_Visible );
				}
				if ( erc.isValid() ) {
					widget->setEraseColor( erc );
				} else if ( erp ) {
					widget->setErasePixmap( *erp );
				}
			}
		}
		q_roll = 0;
		deleteLater();
	}
}

/*
  Delete this after timeout
*/

#include "qeffects.moc"

/*!
    Scroll widget \a w in \a time ms. \a orient may be 1 (vertical), 2
    (horizontal) or 3 (diagonal).
 */
void qScrollEffect( TQWidget* w, TQEffects::DirFlags orient, int time )
{
	if ( q_roll ) {
		delete q_roll;
		q_roll = 0;
	}

	tqApp->sendPostedEvents( w, TQEvent::Move );
	tqApp->sendPostedEvents( w, TQEvent::Resize );
#ifdef TQ_WS_X11
    uint flags = TQt::WStyle_Customize | TQt::WNoAutoErase | TQt::WStyle_StaysOnTop
	| (w->isPopup() ? TQt::WType_Popup : (TQt::WX11BypassWM | TQt::WStyle_Tool));
#else
    uint flags = TQt::WStyle_Customize | TQt::WType_Popup | TQt::WX11BypassWM | TQt::WNoAutoErase | TQt::WStyle_StaysOnTop;
#endif

    // those can popups - they would steal the focus, but are disabled
    q_roll = new TQRollEffect( w, flags, orient );
    q_roll->run( time );
}

/*!
    Fade in widget \a w in \a time ms.
 */
void qFadeEffect( TQWidget* w, int time )
{
	if ( q_blend ) {
		delete q_blend;
		q_blend = 0;
	}

	tqApp->sendPostedEvents( w, TQEvent::Move );
	tqApp->sendPostedEvents( w, TQEvent::Resize );

#ifdef TQ_WS_X11
    uint flags = TQt::WStyle_Customize | TQt::WNoAutoErase | TQt::WStyle_StaysOnTop
	| (w->isPopup() ? TQt::WType_Popup : (TQt::WX11BypassWM | TQt::WStyle_Tool));
#else
    uint flags = TQt::WStyle_Customize | TQt::WType_Popup | TQt::WX11BypassWM | TQt::WNoAutoErase | TQt::WStyle_StaysOnTop;
#endif

    // those can popups - they would steal the focus, but are disabled
    q_blend = new TQAlphaWidget( w, flags );

    q_blend->run( time );
}
#endif //TQT_NO_EFFECTS

#endif // #if 0
