/***************************************************************************
 *   Copyright (C) 2006 by Petri Damsten                                   *
 *   damu@iki.fi                                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KGPGME_H
#define KGPGME_H

#ifdef HAVE_LIBGPGME

#include <gpgme.h>
#include <tqstringlist.h>

/**
	@author Petri Damsten <damu@iki.fi>
*/

class KGpgKey
{
	public:
		TQString id;
		TQString name;
		TQString email;
};

typedef TQValueList< KGpgKey > KGpgKeyList;

class KGpgMe
{
	public:
		KGpgMe();
		~KGpgMe();

		TQString selectKey(TQString previous = TQString());
		KGpgKeyList keys(bool privateKeys = false) const;
		void setText(TQString text, bool saving) { m_text = text; m_saving = saving; };
		void setUseGnuPGAgent(bool use) { m_useGnuPGAgent = use; setPassphraseCb(); };
		TQString text() const { return m_text; };
		bool saving() const { return m_saving; };
		void clearCache();

		bool encrypt(const TQByteArray& inBuffer, TQ_ULONG length,
					 TQByteArray* outBuffer, TQString keyid = TQString());
		bool decrypt(const TQByteArray& inBuffer, TQByteArray* outBuffer);

		static TQString checkForUtf8(TQString txt);
		static bool isGnuPGAgentAvailable();

	private:
		gpgme_ctx_t m_ctx;
		TQString m_text;
		bool m_saving;
		bool m_useGnuPGAgent;
		TQCString m_cache;

		void init(gpgme_protocol_t proto);
		gpgme_error_t readToBuffer(gpgme_data_t in, TQByteArray* outBuffer) const;
		void setPassphraseCb();
		static gpgme_error_t passphraseCb(void *hook, const char *uid_hint,
										  const char *passphrase_info,
										  int last_was_bad, int fd);
		gpgme_error_t passphrase(const char *uid_hint,
								 const char *passphrase_info,
								 int last_was_bad, int fd);
};
#endif																  // HAVE_LIBGPGME
#endif																  // KGPGME_H
