/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef BACKUP_H
#define BACKUP_H

#include <kdialogbase.h>
#include <tqapplication.h>
#include <tqthread.h>

/**
 * @author Sbastien Laot
 */
class BackupDialog : public KDialogBase
{
  Q_OBJECT
  
  public:
	BackupDialog(TQWidget *parent = 0, const char *name = 0);
	~BackupDialog();
  private slots:
	void moveToAnotherFolder();
	void useAnotherExistingFolder();
	void backup();
	void restore();
	void populateLastBackup();
  private:
	TQLabel *m_lastBackup;
};

/**
 * @author Sbastien Laot <slaout@linux62.org>
 */
class KDE_EXPORT Backup
{
  public:
	static void figureOutBinaryPath(const char *argv0, TQApplication &app);
	static void setFolderAndRestart(const TQString &folder, const TQString &message);
	static TQString newSafetyFolder();

  private:
	static TQString binaryPath;
};

class BackupThread : public TQThread
{
  public:
	BackupThread(const TQString &tarFile, const TQString &folderToBackup);
  protected:
	virtual void run();
  private:
	TQString m_tarFile;
	TQString m_folderToBackup;
};

class RestoreThread : public TQThread
{
  public:
	RestoreThread(const TQString &tarFile, const TQString &destFolder);
	inline bool success() { return m_success; }
  protected:
	virtual void run();
  private:
	TQString m_tarFile;
	TQString m_destFolder;
	bool m_success;
};

#endif // BACKUP_H
