/*
 * kaffeine.h
 *
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 * Copyright (C) 2005-2006 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef KAFFEINE_H
#define KAFFEINE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqtimer.h>
#include <tqvbox.h>

#include <tdemainwindow.h>
#include <tdeparts/part.h>

#include "kaffeineiface.h"

class TDEActionMenu;
class TDECmdLineOptions;
class TDERecentFilesAction;
class TDEToggleAction;
class TDEToggleFullScreenAction;

class CdWidget;
class Disc;
class DvbPanel;
class InputManager;
class KaffeinePart;
class MRL;
class PlayList;
class PlayerContainer;
class StartWindow;
class SystemTray;

extern const TDECmdLineOptions cmdLineOptions[];

class Kaffeine : public TDEMainWindow, private KaffeineIface
{
	Q_OBJECT
  
public:
	Kaffeine();
	virtual ~Kaffeine();

	void updateArgs();

private:
	/**
	 * Use this method to load whatever file/URL you have
	 */
	void load(const TQStringList&);
	void load(const TQString&);
	/**
	  * Load urls from command line into the "NEW" playlist
	  * @returns if any url like "DVD", "VCD" was found
	  */
	bool loadTMP(const TQStringList&);

	void setDevice(const TQString& device)
	{
		m_device = device;
	}

	/*
	 * DCOP functions...
	 */
	void openURL(TQString url);
	void appendURL(TQString url);
	void play();
	void playAudioCD();
	void playVCD();
	void playDVD();
	void pause();
	void stop();
	void next();
	void previous();
	void changePlaylist();
	bool isPlaying();
	bool isVideo();
	TQString title();
	TQString artist();
	TQString album();
	TQString track();
	TQString getFileName();
	void random();
	void fullscreen();
	void minimal();
	int getLength();
	int getTimePos();
	void posPlus();
	void posMinus();
	void volUp();
	void volDown();
	void mute();
	void quit();
	void setNumber( int num );
	void dvbNewTimer( TQString name, TQString channel, TQString datetime, TQString duration );
	int dvbSNR( int device );
	void dvbOSD();
	void dvbOSDNextChannel();
	void dvbOSDPreviousChannel();
	void dvbOSDNextProgram();
	void dvbOSDPreviousProgram();
	void dvbOSDZap();
	void playDvb();

public slots:
	void slotPlay(const MRL&);
	void slotLoadURLS(const TQStringList&);
	void slotSwitchToPlayerWindow();
	void slotChangeStatusbar(const TQString&);
	void slotChangePlaylistStatus(const TQString&);
	void slotStop();
	void slotPlayUnPause();

private:
	void showEvent(TQShowEvent*);
	void hideEvent(TQHideEvent*);

	void closeEvent(TQCloseEvent*);
	//  void dragEnterEvent(TQDragEnterEvent*);
	//  void dropEvent(TQDropEvent*);
	void mouseDoubleClickEvent(TQMouseEvent*);
	void mouseMoveEvent(TQMouseEvent*);
	void mousePressEvent(TQMouseEvent*);
	void resizeEvent(TQResizeEvent*);

private slots:
	void slotOpenFile();
	void slotQuit();
	void optionsConfigureKeys();
	void optionsConfigureToolbars();
	void applyNewToolbarConfig();
	void slotFakeKeyEvent();
	void slotChangeCaption(const TQString&);
	void slotOpenURL();
	void slotOpenDirectory();
	void slotPlaylistPlay();
	void slotNext();
	void slotRequestForCurrentTrack();
	void slotRequestForNextTrack();
	void slotRequestForPreviousTrack();
	void slotRequestForTrackNumber();
	void slotPlayRecent(const KURL&);
	void slotMetaFromPlayer(const MRL &mrl);
	void slotToggleFullscreen();
	void slotEscapeFullscreen();
	void slotToggleMinimalMode();
	void slotToggleMinimalModeFromPlayer();
	void slotTogglePlaylist();
	void slotPreferences();
	void slotOriginalAspect();
	void slotAutoresizeOff();
	void slotAutoresizeOriginal();
	void slotAutoresizeDouble();
	void slotAutoresizeTriple();
	void slotNewFrameSize(const TQSize&);
	void slotCurrentTabChanged(TQWidget*);
	void slotClearRecent();
	void slotLoadPart(const TQString&);
	void slotLoadingCanceled(const TQString&);
	void slotPlaybackFailed();
	void slotSystemTray(bool);
	void slotUseAlternateEncoding(bool);
	void slotAlternateEncoding(const TQString&);
	void slotMute();
	void slotSleepAfterPlay();
	void slotSleepAfterPlayMenu();
	void slotQuitAfterPlay();
	void slotQuitAfterPlayMenu();
	void slotQuitAfterPlaylistMenu();
	void slotSetOSDTimeout(uint);
	void slotPauseVideo(bool);
	void slotDvbClient(bool,const TQString&,int,int,const TQString&);
	void slotNumKeyInput( int );
	void slotDVBNextBack( int );
	void slotInstWizard();

private:
	void autoresize();
	void setupAccel();
	void setupActions();
	void loadConfig();
	void saveConfig();
	void hideToolbars(bool);
	TQString askForOtherDevice(const TQString&);
	void unloadCurrentPart();

	KaffeinePart* m_mediaPart;

	InputManager *inplug;

	TQHBox *mainbox;
	TQVBox *playerWidget;
	PlayerContainer* m_playerContainer;
	PlayList* m_playlist;
	Disc *cddisc;
#ifdef HAVE_DVB
	DvbPanel *dvbPanel;
#endif
	CdWidget *dvbClient;
	StartWindow *m_startWindow;

	bool m_dvbClientEnabled;
	TQString m_dvbClientAddress;
	int m_dvbClientPort;
	int m_dvbClientInfo;
	TQString m_dvbClientShiftPath;
	SystemTray* m_systemTray;
	TQSize m_videoSize;
	bool m_noResize;
	bool m_embedSystemTray;
	bool m_sleepInfo;
	uint m_osdDuration;
	uint m_autoResizeFactor;

	bool m_useAlternateEncoding;
	TQString m_alternateEncoding;

	bool m_autoPaused;
	bool m_pauseVideo;

	bool m_haveKWin;

	bool haveXTest;
	int fakeKeycode;

	TQString m_currentPartService;

	TQString m_device;
	TQString m_filter;
	TQStringList m_engineParameters;

	TDERecentFilesAction* m_recent;
	TDEToggleFullScreenAction* m_fullscreen;
	TDEToggleAction* m_minimal;
	TDEToggleAction* m_autoResizeOff;
	TDEToggleAction* m_autoResizeOriginal;
	TDEToggleAction* m_autoResizeDouble;
	TDEToggleAction* m_autoResizeTriple;
	TDEToggleAction* m_originalAspect;
	TDEToggleAction* m_toggleLayout;
	TDEActionMenu*   m_playersMenu;
	TDEAction*       m_instWizard;
	TDEToggleAction* m_sleepAfterPlay;
	TDEToggleAction* m_quitAfterPlay;
	TDEToggleAction* m_quitAfterPlaylist;
	bool m_statusBarVisible;

	TQTimer m_screensaverTimer;
	TQTimer m_numKeyHideTimer;
	int m_numKey;
	TQString m_captionCache;

signals:
	void showOSD( const TQString &text, int duration, int priority );

private:
	Kaffeine(const Kaffeine &);
	Kaffeine &operator=(const Kaffeine &);
};

#endif /* KAFFEINE_H */
