/*
 *
 * $Id: k3bburningoptiontab.h 619556 2007-01-03 17:38:12Z trueg $
 * Copyright (C) 2003 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2007 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */


#ifndef K3B_BURNING_OPTION_TAB_H
#define K3B_BURNING_OPTION_TAB_H

#include <tqwidget.h>

class TQCheckBox;
class TQLabel;
class TQGroupBox;
class TQComboBox;
class TQString;
class TQSpinBox;
class KIntNumInput;
class TQRadioButton;



class K3bBurningOptionTab : public TQWidget
{
Q_OBJECT
  

 public:
  K3bBurningOptionTab( TQWidget* parent = 0, const char* name = 0 );
  ~K3bBurningOptionTab();

  void saveSettings();
  void readSettings();

 private slots:
  void slotSetDefaultBufferSizes( bool );

 private:
  void setupGui();

  TQCheckBox*    m_checkBurnfree;
  TQCheckBox*    m_checkEject;
  TQCheckBox*    m_checkAutoErasingRewritable;
  TQCheckBox*    m_checkOverburn;
  TQCheckBox*    m_checkManualWritingBufferSize;
  KIntNumInput* m_editWritingBufferSize;
  TQCheckBox*    m_checkAllowWritingAppSelection;
  TQCheckBox*    m_checkForceUnsafeOperations;
};


#endif
