#################################################
#
#  (C) 2010 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


find_package( Threads )
find_package( X11 )

check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( systems.h HAVE_SYSTEMS_H )

##### check for inotify ###########################

if( WITH_INOTIFY )
  check_include_file( "inotify.h" INOTIFY_FOUND )
  check_include_file( "sys/inotify.h" INOTIFY_SYS_FOUND )
  if( NOT INOTIFY_FOUND )
    if( NOT INOTIFY_SYS_FOUND )
      message(FATAL_ERROR "\ninotify support was requested, but inotify was not found on your system" )
    endif( NOT INOTIFY_SYS_FOUND )
  endif( NOT INOTIFY_FOUND )
  if( INOTIFY_FOUND )
      set( HAVE_INOTIFY 1 )
  endif( INOTIFY_FOUND )
  if( INOTIFY_SYS_FOUND )
      set( HAVE_INOTIFY 1 )
      set( HAVE_SYS_INOTIFY 1 )
  endif( INOTIFY_SYS_FOUND )
endif( )

check_function_exists( statvfs HAVE_STATVFS )


# sched_setaffinity buggy glibc check
check_c_source_compiles("
  #define _GNU_SOURCE
  #include <sched.h>
  int main() {
    cpu_set_t mask;
    CPU_ZERO(&mask);
    CPU_SET(0, &mask);
    sched_setaffinity(0, sizeof(mask), &mask);
    return 0;
  } "
  SCHEDAFFINITY_3PARAMS )

if( SCHEDAFFINITY_3PARAMS )
  set( SCHEDAFFINITY_SUPPORT 1 )
else( )
  check_c_source_compiles("
  #define _GNU_SOURCE
  #include <sched.h>
  int main() {
    cpu_set_t mask;
    CPU_ZERO(&mask);
    CPU_SET(0, &mask);
    sched_setaffinity(0, &mask);
    return 0;
  } "
  SCHEDAFFINITY_SUPPORT )
endif( )


# fabsf
tde_save( CMAKE_REQUIRED_LIBRARIES )
set( CMAKE_REQUIRED_LIBRARIES m )
check_function_exists( fabsf HAVE_FABSF )
tde_restore( CMAKE_REQUIRED_LIBRARIES )


# taglib
pkg_search_module( TAGLIB taglib )
if( TAGLIB_FOUND )
  if( ${TAGLIB_VERSION} VERSION_LESS "1.5" )
    tde_message_fatal( "taglib version must be at least 1.5" )
  else( )
    set( TAGLIB_15 1 )
    message( STATUS "Found TAGLIB: ${TAGLIB_INCLUDE_DIRS}" )
  endif( )
else( )
  tde_message_fatal( "taglib is required, but not found on your system" )
endif( )


# libvisual
if( WITH_LIBVISUAL )

  pkg_search_module( SDL sdl )
  if( NOT SDL_FOUND )
    check_include_file( SDL/SDL.h HAVE_SDL_H )
    if( NOT HAVE_SDL_H )
      tde_message_fatal( "SDL is required, but not found on your system" )
    endif ( )
    set ( SDL_INCLUDE_DIRS /usr/include/SDL )
    set ( SDL_LIBRARIES SDL pthread )
  endif( )

  pkg_search_module( LIBVISUAL libvisual-0.4 )
  if( LIBVISUAL_FOUND )
    if( ${LIBVISUAL_VERSION} VERSION_LESS "0.4.0" )
      tde_message_fatal( "libvisual version must be at least 0.4.0" )
    endif( )
  else( )
    tde_message_fatal( "libvisual is requested, but not found on your system" )
  endif( )
  set( HAVE_LIBVISUAL 1 )

endif( )


# xine-engine
if( WITH_XINE )
  pkg_search_module( XINE libxine )
  if( XINE_FOUND )
    if( ${XINE_VERSION} VERSION_LESS "1.0.2" )
      tde_message_fatal( "your xine version is too old; at least 1.0.2 is required" )
    endif( )
  else( )
    tde_message_fatal( "xine is requested, but was not found on your system" )
  endif( )
endif( )

# akode-engine
if( WITH_AKODE )
  pkg_search_module( AKODE akode )
  if( AKODE_FOUND )
    if( ${AKODE_VERSION} VERSION_LESS "2.0.0" )
      tde_message_fatal( "your akode version is too old; at least 2.0.0 is required" )
    endif( )
  else( )
    tde_message_fatal( "akode is requested, but was not found on your system" )
  endif( )
endif( )


##### check for libgpod - iPod

if( WITH_IPOD )

pkg_search_module( GLIB2 glib-2.0 )

  pkg_search_module( GPOD libgpod-1.0 )
  if( GPOD_FOUND )
    if( ${GPOD_VERSION} VERSION_LESS "0.4.2" )
      tde_message_fatal( "your libgpod version is too old; at least 0.4.2 is required" )
    elseif( NOT ${GPOD_VERSION} VERSION_LESS "0.6.0" )
      set( HAVE_GPOD_060 1 )
    endif( )
  else( )
    tde_message_fatal( "libgpod-1.0 is requested, but was not found on your system" )
  endif( )

  tde_save( CMAKE_REQUIRED_INCLUDES )
  set( CMAKE_REQUIRED_INCLUDES ${GPOD_INCLUDE_DIRS} )
  check_struct_has_member( "struct _Itdb_Track" mediatype "gpod/itdb.h" HAVE_ITDB_MEDIATYPE )
  tde_restore( CMAKE_REQUIRED_INCLUDES )

  set( GPOD_LIBRARY gpod )

endif( )


if( WITH_OPENGL )
set( OpenGL_GL_PREFERENCE LEGACY )
find_package( GLUT )
find_package( OpenGL )

##### check for OpenGL support within tqt

tde_save( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
set( CMAKE_REQUIRED_INCLUDES ${TQT_INCLUDE_DIRS} )
set( CMAKE_REQUIRED_LIBRARIES -L${TQT_LIBRARY_DIRS} ${TQT_LIBRARIES} )

check_cxx_source_compiles("
#include <cstdlib>
#include <tqgl.h>
int main( int, char** )
{
	(void) new TQGLWidget( (TQWidget*)0, \"qgl\" ) ;
	return EXIT_SUCCESS ;
}"
HAVE_TQGLWIDGET )

tde_restore( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
endif( WITH_OPENGL )


# konqsidebarplugin.h
if( WITH_KONQSIDEBAR )
  tde_save( CMAKE_REQUIRED_DEFINITIONS CMAKE_REQUIRED_FLAGS CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
  set( CMAKE_REQUIRED_DEFINITIONS ${TQT_CFLAGS_OTHER} )
  set( CMAKE_REQUIRED_INCLUDES ${TDE_INCLUDE_DIR};${TQT_INCLUDE_DIRS};${CMAKE_INCLUDE_PATH} )
  set( CMAKE_REQUIRED_FLAGS "-include tqt.h" )
  set( CMAKE_REQUIRED_LIBRARIES -L${TQT_LIBRARY_DIRS} -L${QT_LIBRARY_DIRS} ${TQT_LIBRARIES} )
  check_cxx_source_compiles("
    #include <konqsidebarplugin.h>
    int main(int, char**) { return 0; } "
    HAVE_KONQSIDEBARPLUGIN_H )
  tde_restore( CMAKE_REQUIRED_DEFINITIONS CMAKE_REQUIRED_FLAGS CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
  if( NOT HAVE_KONQSIDEBARPLUGIN_H )
    tde_message_fatal( "Konqueror sidebar is requested, but konqsidebarplugin.h was not found on your system" )
  endif( )
endif( )


if( WITH_MP4V2 )
##### check for mp4v2

check_include_file( "mp4v2/mp4v2.h" MP4V2_H_FOUND )
if( MP4V2_H_FOUND )
    set( HAVE_MP4V2_H 1)

    find_path( MP4V2_INCLUDE_DIR "mp4v2/mp4v2.h" )
    set( MP4V2_INCLUDE_DIRS "${MP4V2_INCLUDE_DIR}" )

    find_library( MP4V2_LIBRARY mp4v2 )
    set( MP4V2_LIBRARIES "${MP4V2_LIBRARY}" )
endif()

check_include_file( "mp4.h" MP4_H_FOUND )
if( MP4_H_FOUND )
    set( HAVE_MP4_H 1)

    find_path( MP4_INCLUDE_DIR "mp4.h" )
    set( MP4V2_INCLUDE_DIRS "${MP4_INCLUDE_DIR}" )

    find_library( MP4_LIBRARY mp4 )
    set( MP4V2_LIBRARIES "${MP4_LIBRARY}" )
endif()

if( HAVE_MP4V2_H OR HAVE_MP4_H )
    set( HAVE_MP4V2 1 )
  else()
    tde_message_fatal( "MP4V2 support was requested but was not found on your system" )
endif()
endif( WITH_MP4V2 )


if( WITH_MYSQL )
  #### check for MySql or Mariadb

  message( STATUS "Check for MariaDB or MySQL" )
  find_program( MYSQL_CONFIG NAMES mariadb_config mysql_config )

  if( NOT MYSQL_CONFIG )
    tde_message_fatal( "MySql support is requested but neither MySql or Mariadb have been found on your system" )
  else()

  macro( _mysql_config  __type __var )
    execute_process(
      COMMAND ${MYSQL_CONFIG} --${__type}
      OUTPUT_VARIABLE ${__var}
      RESULT_VARIABLE __result
      OUTPUT_STRIP_TRAILING_WHITESPACE )
    if( _result )
      tde_message_fatal( "Unable to run ${MYSQL_CONFIG}!" )
    endif()
  endmacro()

  _mysql_config( include MYSQL_INCLUDE_DIRS )
  _mysql_config( libs   MYSQL_LIBRARIES    )

  if( MYSQL_INCLUDE_DIRS )
    string( REGEX REPLACE "(^| +)-I" ";" MYSQL_INCLUDE_DIRS "${MYSQL_INCLUDE_DIRS}" )
  endif()

  if( MYSQL_LIBRARIES )
    string( REGEX REPLACE "(^| +)-l" ";" MYSQL_LIBRARIES "${MYSQL_LIBRARIES}" )
  endif( )

  set( MYSQL_INCLUDE_DIRS "${MYSQL_INCLUDE_DIRS}" CACHE INTERNAL "" FORCE )
  set( MYSQL_LIBRARIES "${MYSQL_LIBRARIES}" CACHE INTERNAL "" FORCE )

  message( STATUS "    includes ${MYSQL_INCLUDE_DIRS} ")
  message( STATUS "    libraries ${MYSQL_LIBRARIES} ")
  set( USE_MYSQL 1 )

  tde_save_and_set( CMAKE_REQUIRED_INCLUDES ${MYSQL_INCLUDE_DIRS} )

  check_cxx_source_compiles("
    #include <mysql.h>
    typedef struct st_mysql MYSQL;
    int main(int, char**)
    {
	 return 1;
    }"
    HAVE_STRUCT_ST_MYSQL )

  if( HAVE_STRUCT_ST_MYSQL )
    set( MYSQL_STRUCT "st_mysql" )
  else()
    check_cxx_source_compiles("
      #include <mysql.h>
      typedef struct MYSQL MYSQL;

      int main()
      {
        return 1;
      }"
      HAVE_STRUCT_MYSQL )

    if( HAVE_STRUCT_MYSQL )
      set( MYSQL_STRUCT "MYSQL" )
    else()
      tde_message_fatal( "MySQL is requested, but it is not possible to determine the type of MySQL structure" )
    endif()
  endif()

  tde_restore( CMAKE_REQUIRED_INCLUDES )

  endif( NOT MYSQL_CONFIG )

endif( WITH_MYSQL )


if( WITH_POSTGRESQL )
##### check for PostgreSQL

  message( STATUS "Check for PostgreSQL" )
  find_package( PostgreSQL )

  if( PostgreSQL_INCLUDE_DIR AND PostgreSQL_LIBRARY )
    message( STATUS "    includes ${PostgreSQL_INCLUDE_DIR} ")
    message( STATUS "    library ${PostgreSQL_LIBRARY} ")
    set( USE_POSTGRESQL 1 )
  else()
    pkg_search_module( LIBPQ libpq )

    if( NOT LIBPQ_FOUND )
      tde_message_fatal( "Postgresql support is requested but Postgresql was not found on your system." )
    endif()

    set( PostgreSQL_INCLUDE_DIR "${LIBPQ_INCLUDE_DIRS}" )
    set( PostgreSQL_LIBRARY "${LIBPQ_LIBRARIES}" )
    set( PostgreSQL_LIBRARY_DIRS "${LIBPQ_LIBRARY_DIRS}" )
    set( USE_POSTGRESQL 1 )
  endif()

endif( WITH_POSTGRESQL )


if( WITH_EMBEDDED_SQLITE )
  set( SQLITE_LIBRARIES sqlite-static )
  message( STATUS "sqlite3 linking: ${SQLITE_LIBRARIES}" )
endif()


if( WITH_SYSTEM_SQLITE )
##### check for sqlite3

pkg_search_module( SQLITE sqlite3 )
if( NOT SQLITE_FOUND )
    tde_message_fatal( "sqlite3 is required, but not found on your system" )
  else()
    message( STATUS "sqlite3 linking: ${SQLITE_LIBRARIES}" )
endif( )
endif( WITH_SYSTEM_SQLITE )

if( WITH_AMAZON )
    set( AMAZON_SUPPORT 1 )
endif()
