/***************************************************************************
    smb4ksuperuseroptions  -  The configuration page for the super user
    settings of Smb4K
                             -------------------
    begin                : Sa Okt 30 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqgroupbox.h>
#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>

// KDE includes
#include <tdelocale.h>
#include <kpushbutton.h>
#include <kguiitem.h>

// application specific includes
#include "smb4ksuperuseroptions.h"
#include "../core/smb4ksettings.h"


Smb4KSuperUserOptions::Smb4KSuperUserOptions( TQWidget *parent, const char *name )
: TQWidget( parent, name )
{
  TQGridLayout *grid =           new TQGridLayout( this );
  grid->setSpacing( 10 );

  TQButtonGroup *suid_progs =    new TQButtonGroup( 1, Qt::Horizontal,
                                i18n( "Programs" ), this, "kcfg_SuperUserProgram" );
  suid_progs->setInsideSpacing( 5 );

  new TQLabel( i18n( "Use the following program to gain super user privileges:" ), suid_progs );
  suid_progs->insert( new TQRadioButton( "sudo", suid_progs, "SudoButton" ), Smb4KSettings::EnumSuperUserProgram::Sudo );
  suid_progs->insert( new TQRadioButton( "super", suid_progs, "SuperButton" ), Smb4KSettings::EnumSuperUserProgram::Super );

  TQButtonGroup *suid_actions =  new TQButtonGroup( 1, Qt::Horizontal, i18n( "Actions" ), this, "SUIDActions" );
  suid_actions->setInsideSpacing( 5 );
#ifdef __linux__
  (void) new TQCheckBox( i18n( "Use super user privileges to force the unmounting of (inaccessible) shares" ), suid_actions, "kcfg_UseForceUnmount" );
#endif
  (void) new TQCheckBox( i18n( "Use super user privileges to mount and unmount shares" ), suid_actions, "kcfg_AlwaysUseSuperUser" );

  TQSpacerItem *spacer1 =        new TQSpacerItem( 0, 0, TQSizePolicy::Expanding, TQSizePolicy::Preferred );
  KGuiItem remove_item =        KGuiItem(  i18n( "Remove Entries" ), "edit-delete",
                                i18n( "Remove entries from the configuration file" ),
                                i18n( "Depending on your choice under \"Programs\", all entries that were written by Smb4K will be removed either from /etc/super.tab or /etc/sudoers. Additionally, all your choices under \"Actions\" will be cleared." ) );
  KPushButton *remove =         new KPushButton( remove_item, this, "RemoveButton" );

  TQSpacerItem *spacer2 =        new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  grid->addMultiCellWidget( suid_progs, 0, 0, 0, 3, 0 );
  grid->addMultiCellWidget( suid_actions, 1, 1, 0, 3, 0 );
  grid->addMultiCell( spacer1, 2, 2, 0, 2, 0 );
  grid->addWidget( remove, 2, 3, 0 );
  grid->addMultiCell( spacer2, 3, 3, 0, 3, 0 );

  connect( remove, TQT_SIGNAL( clicked() ),
           this,   TQT_SLOT( slotRemoveClicked() ) );
}


Smb4KSuperUserOptions::~Smb4KSuperUserOptions()
{
}


/////////////////////////////////////////////////////////////////////////////
// TQT_SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSuperUserOptions::slotRemoveClicked()
{
  // Emit the signal that the removal of the super user
  // entries has been requested.
  emit removeEntries();
}

#include "smb4ksuperuseroptions.moc"
