/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef PREFERENCESDIALOG_H
#define PREFERENCESDIALOG_H

#include <kdialogbase.h>

#include <tqptrlist.h>
#include <tqstringlist.h>
#include <tqtextedit.h>
#include <tqcolor.h>
#include <tqscrollview.h>

#include "vpnaccountdata.h"

// content
#include "configdebugoptions.h"
#include "configgeneraloptions.h"
#include "configconnectoptions.h"
#include "configlogoptions.h"
#include "configdaemonoptions.h"
#include "confighelperprogramoptions.h"
#include "profilecertoptions.h"
#include "profilesmartcardoptions.h"
#include "profilepskoptions.h"
#include "profileciscooptions.h"
#include "profilecmdexecafterconnectoptions.h"
#include "profilecmdexecafterdisconnectoptions.h"
#include "profilecmdexecbeforeconnectoptions.h"
#include "profilecmdexecbeforedisconnectoptions.h"
#include "profilegeneraloptions.h"
#include "profilenetworkgeneraloptions.h"
#include "profilenetworknatoptions.h"
#include "profilenetworkhttpproxyoptions.h"
#include "profilenetworkrouteoptions.h"
#include "profilenetworkvirtualipoptions.h"
#include "profileopenvpnoptions.h"
#include "profilepptpoptions.h"
#include "profileracoonoptions.h"
#include "profileipsecoptions.h"
#include "profilevtunoptions.h"
#include "profilesshoptions.h"
#include "profileuseroptions.h"


/**
@author Christoph Thielecke
*/
class PreferencesDialog : public KDialogBase
{
	Q_OBJECT
  
public:

	/**
	 *  Constructor
	 * @param parent parent widget
	 * @param app pointer to main application
	 * @param LogOutput textedit for debug messages
	 * @param GlobalConfig pointer to configuration object
	 * @param showOnlyProfiles view mode. true: show as profile manager, false: show as preferences dialog
	 * @return
	 */
	PreferencesDialog( TQWidget *parent, TQApplication *app,TQTextEdit *LogOutput, KVpncConfig *GlobalConfig, bool showOnlyProfiles);
	~PreferencesDialog();

public slots:
	void accept();
	void reject();
	void slotApply();
	void authTypeChanged( int authtype );
	void connectionTypeChanged( int connectiontype );
	void profileChanged( const TQString& itemtext );
	void saveSessionClicked();
	void deleteSessionClicked();
	void renameSessionClicked();
	void newSessionClicked();
	void importCertificate();
	void pageChanged(TQWidget *);
	void userAuthToggled(bool);
	void useUdpToggled(bool);
	void useSpecialServerSmartcardificateToggled(bool);
	void applicationVersionToggled(bool);
	void IkeGroupToggled(bool);
	void perfectForwardSecurityToggled(bool);
	void singleDesToggled(bool);
	void useTDEwalletToggled(bool);
	void dpdToggled(bool);
	void useCiscoCertStoreToggled(bool);
	void natModeToggled( const TQString &);
	void slotProfileCreated(TQString Name);

private slots:
	void OpenvpnPathChanged(const TQString&);
	void FreeswanPathChanged(const TQString&);
	void PppdPathChanged(const TQString&);
	void PptpPathChanged(const TQString&);
	void RacoonPathChanged(const TQString&);
	void VpncPathChanged(const TQString&);
	void CiscoVpncPathChanged(const TQString&);
	void L2tpdPathChanged(const TQString&);
	void Xl2tpdPathChanged(const TQString&);
	void Openl2tpPathChanged(const TQString&);
	void VtundPathChanged(const TQString&);
	void SshPathChanged(const TQString&);
	void showEvent(TQShowEvent* e);
	void detectPkcs11Ids();
	void detectPkcs11Slots();
	void localPortToggled(bool);
	void tunnelDeviceTypeChanged(const TQString &);
	void useXauthToggled(bool);
	void slotStatusMsg ( const TQString &text, int id );
	bool getVpncHasHybridSupport();


protected:
	void setupGui();
	TQPtrList<VpnAccountData> *AccountList;
	TQTextEdit *LogOutput;
	VpnAccountData *currentProfile;
	KVpncConfig *GlobalConfig;
	TQString lastProfileName;
	int KvpncDebugLevel;
	bool canAccept;
	bool configChanged;
	TQPixmap ok_icon;
	TQPixmap wrong_icon;
	TQScrollView* DaemonScrollView;
	TQStringList CiscoCerts;
	TQStringList CiscoCaCerts;

private:
	TQWidget *prev_page;
	TQWidget *current_page;

public:
	TQApplication *app;

	/* -- option pages -- */
	// Kvpnc
	ConfigGeneralOptions *GeneralOptionsWidget;
	ConfigDebugOptions *DebugOptionsWidget;
	ConfigConnectOptions *ConnectOptionsWidget;
	ConfigLogOptions *LogOptionsWidget;

	// programs
	ConfigDaemonOptions *ConfigDaemonOptionsWidget;
	ConfigHelperProgramOptions *HelperProgramOptionsWidget;

	// profile
	ProfileGeneralOptions *ProfileGeneralOptionsWidget;
	ProfileNetworkRouteOptions *ProfileNetworkRouteOptionsWidget;
	ProfileNetworkGeneralOptions *ProfileNetworkGeneralOptionsWidget;
	ProfileNetworkNatOptions *ProfileNetworkNatOptionsWidget;
	ProfileNetworkVirtualIpOptions *ProfileNetworkVirtualIpOptionsWidget;
	ProfileCertOptions *ProfileCertOptionsWidget;
	ProfileSmartcardOptions *ProfileSmartcardOptionsWidget;
	ProfilePskOptions *ProfilePskOptionsWidget;
	ProfileUserOptions *ProfileUserOptionsWidget;
	ProfileOpenvpnOptions *ProfileOpenvpnOptionsWidget;
	ProfileNetworkHttpProxyOptions *ProfileNetworkHttpProxyOptionsWidget;
	ProfilePptpOptions *ProfilePptpOptionsWidget;
	ProfileRacoonOptions *ProfileRacoonOptionsWidget;
	ProfileIpsecOptions *ProfileIpsecOptionsWidget;
	ProfileCiscoOptions *ProfileCiscoOptionsWidget;
	ProfileVtunOptions *ProfileVtunOptionsWidget;
	ProfileSshOptions *ProfileSshOptionsWidget;
	ProfileCmdExecBeforeConnectOptions *ProfileCmdExecBeforeConnectOptionsWidget;
	ProfileCmdExecBeforeDisconnectOptions *ProfileCmdExecBeforeDisconnectOptionsWidget;
	ProfileCmdExecAfterConnectOptions *ProfileCmdExecAfterConnectOptionsWidget;
	ProfileCmdExecAfterDisconnectOptions *ProfileCmdExecAfterDisconnectOptionsWidget;

	TQFrame* ProfileNetworkRouteOptionsFrame;
	TQFrame* ConfigConnectOptionsFrame;
	TQFrame* DaemonOptionsFrame;
	TQFrame* DebugFrame;
	TQFrame* LogFrame;
	TQFrame* HelperProgramFrame;
	TQFrame* ProfileGeneralOptionsFrame;
	TQFrame* ProfileUserOptionsFrame;
	TQFrame* ProfileCertOptionsFrame;
	TQFrame* ProfileCiscoOptionsFrame;
	TQFrame* ProfileNetworkHttpProxyOptionsFrame;
	TQFrame* ProfileCmdExecAfterConnectOptionsFrame;
	TQFrame* ProfileCmdExecBeforeDisconnectOptionsFrame;
	TQFrame* ProfileCmdExecAfterDisconnectOptionsFrame;
	TQFrame* ProfileCmdExecBeforeConnectOptionsFrame;
	TQFrame* GeneralFrame;
	TQFrame* ProfileSmartcardOptionsFrame;
	TQFrame* ProfilePskOptionsFrame;
	TQFrame* ProfileNetworkGeneralOptionsFrame;
	TQFrame* ProfileNetworkNatOptionsFrame;
	TQFrame* ProfileNetworkVirtualIpOptionsFrame;
	TQFrame* ProfileRacoonOptionsFrame;
	TQFrame* ProfileIpsecOptionsFrame;
	TQFrame* ProfileOpenvpnOptionsFrame;
	TQFrame* ProfilePptpOptionsFrame;
	TQFrame* ProfileVtunOptionsFrame;
	TQFrame* ProfileSshOptionsFrame;


	TQComboBox *ProfileGeneralSelector;
	TQComboBox *ProfileNetworkRouteSelector;
	TQComboBox *ProfileNetworkGeneralSelector;
	TQComboBox *ProfileNetworkNatSelector;
	TQComboBox *ProfileNetworkVirtualIpSelector;
	TQComboBox *ProfileCertSelector;
	TQComboBox *ProfileSmartcardSelector;
	TQComboBox *ProfilePskSelector;
	TQComboBox *ProfileUserSelector;
	TQComboBox *ProfileOpenvpnSelector;
	TQComboBox *ProfileNetworkHttpProxySelector;
	TQComboBox *ProfilePptpSelector;
	TQComboBox *ProfileRacoonSelector;
	TQComboBox *ProfileIpsecSelector;
	TQComboBox *ProfileCiscoSelector;
	TQComboBox *ProfileVtunSelector;
	TQComboBox *ProfileSshSelector;
	TQComboBox *ProfileCmdExecBeforeConnectSelector;
	TQComboBox *ProfileCmdExecBeforeDisconnectSelector;
	TQComboBox *ProfileCmdExecAfterConnectSelector;
	TQComboBox *ProfileCmdExecAfterDisconnectSelector;

	

	bool profileAddedOrDeleted;
	bool profileHasChanged;
	bool showOnlyProfiles;
	TQString NewProfileName;
};

#endif
