//
//   File : kvi_ctcppagedialog.cpp
//   Creation date : Tue May 21 2002 22:09:45 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#define __KVIRC__

#include "kvi_ctcppagedialog.h"

#include "kvi_locale.h"
#include "kvi_app.h"

#include "kvi_iconmanager.h"

#include <tqdatetime.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqpixmap.h>

#ifdef COMPILE_USE_QT4
	#include <tqdesktopwidget.h>
#endif

// kvi_app.cpp
extern KVIRC_API KviCtcpPageDialog * g_pCtcpPageDialog;

KviCtcpPageDialog::KviCtcpPageDialog()
: TQWidget(0,"kvirc_ctcppage_dialog",
#ifdef COMPILE_USE_QT4
		TQt::WindowStaysOnTopHint | TQt::Tool | TQt::Dialog | TQt::Window)
#else
		  WStyle_StaysOnTop | WStyle_Tool | WType_Dialog | WType_TopLevel)
#endif
{
	TQGridLayout * g = new TQGridLayout(this,4,1,6,0);
	m_pWidgetStack = new KviTalWidgetStack(this);
	g->addWidget(m_pWidgetStack,0,0);
	m_pTabBar = new TQTabBar(this);
	m_pTabBar->setShape(TQTabBar::TriangularBelow);
	connect(m_pTabBar,TQT_SIGNAL(selected(int)),this,TQT_SLOT(tabSelected(int)));
	g->addWidget(m_pTabBar,1,0);

	g->setRowStretch(0,1);

	g->addRowSpacing(2,15);

	m_pCloseButton = new TQPushButton(__tr2qs("Close"),this);
	connect(m_pCloseButton,TQT_SIGNAL(clicked()),this,TQT_SLOT(die()));
	g->addWidget(m_pCloseButton,3,0);

	setMinimumSize(300,200);
	setMaximumSize(780,580);
	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_CTCPREQUESTREPLIED)));

	setCaption(__tr2qs("CTCP Page - KVIrc"));
}

KviCtcpPageDialog::~KviCtcpPageDialog()
{
	g_pCtcpPageDialog = 0;
}

void KviCtcpPageDialog::center()
{
	move((g_pApp->desktop()->width() - width()) >> 1,
		(g_pApp->desktop()->height() - height()) >> 1);
}

void KviCtcpPageDialog::die()
{
	delete this;
}

void KviCtcpPageDialog::tabSelected(int id)
{
	m_pWidgetStack->raiseWidget(id);
}

void KviCtcpPageDialog::addPage(const TQString &szNick,const TQString &szUser,const TQString &szHost,const TQString &szMsg)
{
#ifdef COMPILE_USE_QT4
	int id = m_pTabBar->addTab(szNick);
#else
	int id = m_pTabBar->addTab(new TQTab(szNick));
#endif
	TQLabel * l = new TQLabel(this);
	l->setFrameStyle(TQFrame::Raised | TQFrame::StyledPanel);
	//l->setMaximumWidth(600);
	TQString date = TQDateTime::currentDateTime().toString();

	TQString tmp = "<center>";
	tmp += __tr2qs("You have been paged by");
	tmp += "<br><b>";
	tmp += szNick;
	tmp += " [";
	tmp += szUser;
	tmp += "@";
	tmp += szHost;
	tmp += "]</b>:<br><br><b>";
	tmp += szMsg;
	tmp += "</b><br><br>[";
	tmp += date;
	tmp += "]</center>";

	l->setText(tmp);
	m_pWidgetStack->addWidget(l,id);
	m_pWidgetStack->raiseWidget(l);
	m_pTabBar->setCurrentTab(id);
}

void KviCtcpPageDialog::closeEvent(TQCloseEvent *)
{
	delete this;
}

void KviCtcpPageDialog::popup()
{
	show();
//	raise();
//	setActiveWindow();
	m_pCloseButton->setFocus();
}

void KviCtcpPageDialog::showEvent(TQShowEvent *e)
{
	TQWidget::showEvent(e);
	center();
}

#include "kvi_ctcppagedialog.moc"
