/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  ServerListView is derived from TDEListView and implements custom
  drag'n'drop behavior needed in ServerListDialog.

  Copyright (C) 2006 Eike Hein <hein@kde.org>
*/

#ifndef SERVERLISTVIEW_H
#define SERVERLISTVIEW_H

#include <tdelistview.h>


class TQDragObject;

class ServerListView : public TDEListView
{
    Q_OBJECT
  

    public:
        explicit ServerListView(TQWidget *parent);
        ~ServerListView();

        TQPtrList<TQListViewItem> selectedServerListItems();

    protected:
        void findDrop(const TQPoint &pos, TQListViewItem *&parent, TQListViewItem *&after);
        TQDragObject* dragObject();
};

#endif
