/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2006 by the KFTPGrabber developers
 * Copyright (C) 2003-2006 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
#ifndef KFTPCORE_CUSTOMCOMMANDSMANAGER_H
#define KFTPCORE_CUSTOMCOMMANDSMANAGER_H

#include <tqobject.h>
#include <tqdom.h>
#include <tqmap.h>

#include <tdeaction.h>

#include "handlers.h"

namespace KFTPSession {
  class Session;
}

namespace KFTPCore {

namespace CustomCommands {

/**
 * This class represents the entry manager. It parses the XML file and
 * creates the necessary entries. This class is a singleton.
 *
 * @author Jernej Kos
 */
class Manager : public TQObject {
Q_OBJECT
public:
    /**
     * Class destructor.
     */
    ~Manager();
    
    /**
     * Returns a Manager instance.
     */
    static Manager *self();
    
    /**
     * Returns an appropriate handler.
     *
     * @param name Handler string identifier
     */
    Handlers::Handler *handler(const TQString &name) const;
    
    /**
     * Returns a TDEActionMenu that can be used for displaying categories of
     * entries to the user.
     */
    TDEActionMenu *categories(const TQString &name, KFTPSession::Session *session) const;
public slots:
    /**
     * Loads a valid commands XML file.
     */
    void load();
protected:
    static Manager *m_self;
    
    /**
     * Class constructor.
     */
    Manager();
    
    /**
     * Recursive entry parser.
     */
    void parseEntries(TDEActionMenu *parentMenu, const TQDomNode &parentNode, KFTPSession::Session *session) const;
protected slots:
    /**
     * This slot gets called when an EntryAction is activated.
     */
    void slotActionActivated();
private:
    TDEActionMenu *m_categories;
    TQDomDocument m_document;
    TQMap<TQString, Handlers::Handler*> m_handlers;
};

}

}

#endif
