//
// C++ Interface: ftpsession
//
// Description: 
//
//
// Author: Magnus Kulke <sikor_sxe@radicalapproach.de>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef FTPSESSION_H
#define FTPSESSION_H

#include <kprocess.h>
#include <tqstring.h>
#include <tqdir.h>
#include <tqpixmap.h>
#include <tqobject.h>
#include <tqcolor.h>
#include <list>

#include "kbfileinfo.h"

using namespace std;

class FtpThread;
class EventHandler;
class TQMutex;
class TQTextEdit;
class TQToolButton;
class TQListView;
class KbSiteInfo;
class TQPopupMenu;
class KLineEdit;
class TQLabel;
class TQPoint;
class KbDirInfo;
class TQHeader;
class KbTransferItem;

typedef pair<TQString, bool> logentries;

/**
@author Magnus Kulke
*/
class FtpSession : public TQObject
{
Q_OBJECT
public:
	enum filecheck
	{
		off = 0,
		skip,
		clear,
		resume
	};
public:
	FtpSession(TQObject *parent = 0, const char *name = 0);
	~FtpSession();
	void SetLogWindow(TQTextEdit* logwindow) { mp_logwindow = logwindow; };
	void SetRefreshButton(TQToolButton* refreshbutton) { mp_refreshbutton = refreshbutton; };
	void SetConnectButton(TQToolButton* connectbutton) { mp_connectbutton = connectbutton; };
	void SetTransferButton(TQToolButton* transferbutton) { mp_transferbutton = transferbutton; }
	void SetBrowser(TQListView* browser) { mp_browser = browser; };
	void SetStatusLine(TQLabel* statusline) { mp_statusline = statusline; };
	void SetEncryptionIcon(TQLabel* encryptionicon) { mp_encryptionicon = encryptionicon; };
	void SetBookmarksMenu(TQPopupMenu *bookmarksmenu) { mp_bookmarksmenu = bookmarksmenu; };
	void SetRclickMenu(TQPopupMenu *rclickmenu) { mp_rclickmenu = rclickmenu; };
	void SetSessionList(list<FtpSession*> *sessionlist) { mp_sessionlist = sessionlist; };
	void SetCurrentTransfer(KbTransferItem* currenttransfer) { mp_currenttransfer = currenttransfer; };
	bool Connected() { return m_connected; };
	void Disconnect();
	void Connect();
	bool Occupied() { return m_occupied; };
	void Occupy();
	void Free();
	TQString WorkingDir();
 	void Transfer(KbTransferItem *item);
	int CheckFile(KbTransferItem *item);
	void Abort();
	FtpThread* Ftp() { return mp_ftpthread; };
	KbSiteInfo* SiteInfo() { return mp_siteinfo; };
	void SetColors(TQColor local, TQColor success, TQColor failure, TQColor background);
	void SetFont(TQFont font);
	void SetOnFileExistsDefault(filecheck onfileexistsdefault) {m_onfileexistsdefault = onfileexistsdefault; };
	void EnableCmdLine(bool b);
	void FilterHiddenFiles(bool b);
	void SetCmdLine(KLineEdit* cmdline);
	void SetCwdLine(KLineEdit* cwdline);
private:
	FtpThread *mp_ftpthread;
	EventHandler *mp_eventhandler;
	KbSiteInfo *mp_siteinfo;
	TQTextEdit *mp_logwindow;
	TQToolButton *mp_connectbutton, *mp_refreshbutton, *mp_transferbutton;
	KLineEdit *mp_cwdline, *mp_cmdline;
	TQPopupMenu* mp_bookmarksmenu, *mp_rclickmenu;
	TQListView *mp_browser;
	TQLabel *mp_statusline, *mp_encryptionicon;
	TQString m_remoteworkingdir; 
	TQDir m_localworkingdir;
	TQColor m_colorsuccess, m_colorfailure, m_colorlocal;
	TQFont m_logwindowfont;
	int m_sortpref;
	bool m_connected, m_occupied, m_sortascending, m_startqueue;
	list<logentries> m_loglist;
	TQPixmap m_iconencrypted, m_iconunencrypted;
	TQHeader *mp_header;
	list<FtpSession*> *mp_sessionlist;
	KbTransferItem *mp_currenttransfer;
	filecheck m_onfileexistsdefault;
	bool m_encrypted;
	
public slots:
	void SLOT_Log(TQString log, bool out);
	void SLOT_Xfered(off64_t xfered, bool encrypted);
	void SLOT_ActionMenu(int i);
	void SLOT_ConnectMenu(int i);
	void SLOT_HeaderClicked(int section);
	void SLOT_LocalProcessExited(TDEProcess* proc) { delete proc; };
	void SLOT_ItemClicked(TQListViewItem*);
	void SLOT_ItemRClicked(TQListViewItem * item, const TQPoint & point, int col);
	void SLOT_Connect(bool success);
	void SLOT_Login(bool success);
	void SLOT_Pwd(bool success, TQString pwd);
	void SLOT_Misc(bool success);
	void SLOT_AuthTls(bool success);
	void SLOT_EncryptData(bool success);
	void SLOT_Dir(bool success, list<KbFileInfo*> dirlist, list<KbFileInfo*> filelist);
	void SLOT_ConnectButton();
	void SLOT_RefreshButton();
	void SLOT_TransferButton();
	void SLOT_CwdLine();
	void SLOT_CmdLine();
	void SLOT_Finish();
	void SLOT_ConnectionLost();
	void SLOT_Transfer(bool success);
	void SLOT_Scandir(bool success, KbDirInfo* dir);
	
private:
	void PrintLog(bool success);
	void QueueItems();
	void RefreshBrowser();
	void UpdateLocal(TQString cwd = "");
	//bool RmdirLocal(TQString dir);
	void GetFile(KbTransferItem *item, filecheck fc);
	void PutFile(KbTransferItem *item, filecheck fc);
	void FxpFile(KbTransferItem *item, filecheck fc);
	void ChangeDirectory(TQString path);
	bool CheckLocalDirectory(TQString path);
	bool MakeLocalDirectory(TQString path);
	bool CopyLocalFile(KbTransferItem* item);
	bool ScandirLocal(KbDirInfo *dir, TQString path);
	void SortItems();
	void MakeDirectory(TQString dir);
	void timerEvent(TQTimerEvent*);
signals:
	void gui_update();
	void gui_queueitems(KbDirInfo* dir, FtpSession* src, FtpSession* dst, bool startqueue);
	void gui_succeedtransfer(TQListViewItem* item);
	void gui_clearqueue(FtpSession* session);
};

#endif
