/***************************************************************************
                          sq_slideshowwidget.h  -  description
                             -------------------
    begin                : ??? Mar 30 2007
    copyright            : (C) 2007 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQ_SLIDESHOWWIDGET_H
#define SQ_SLIDESHOWWIDGET_H

#include <tqwidget.h>
#include <tqpixmap.h>

class TQTimer;
class TQHBox;
class TQLabel;
class TQToolButton;

/**
  *@author Baryshev Dmitry
  *
  * A widget to show slideshow. It contains toolbar
  *  with some useful actions like "pause", "close", "next image" etc.
  * It also can show onscreen message, which format is configured through
  * "Action -> Slideshow advanced".
  */

class SQ_SlideShowWidget : public TQWidget
{
    Q_OBJECT
  

    public: 
	SQ_SlideShowWidget(TQWidget *parent = 0, const char *name = 0);
	~SQ_SlideShowWidget();

        void beginSlideShow(int totl);
        void endSlideShow();
        void loadImage(const TQString &path, int);

        virtual bool eventFilter(TQObject * watched, TQEvent *e);

        static SQ_SlideShowWidget* instance() { return m_inst; }

    protected:
        /*
         *  Draw decoded image
         */
        virtual void paintEvent(TQPaintEvent *);

        /*
         *  Ignore close event and tell KSquirrel to stop slideshow
         */
        virtual void closeEvent(TQCloseEvent *);

        /*
         *  Return, Escape = stop slideshow
         *  Pause, Space = pause/unpause slideshow
         *  Page Up = previous image
         *  Page Down = next image
         */
        virtual void keyPressEvent(TQKeyEvent *);

        /*
         *  show toolbar with actions
         */
        virtual void mouseMoveEvent(TQMouseEvent *);

    private:
        void constructMessage();

    signals:
        void stopSlideShow();
        void pause();
        void next();
        void previous();

    private slots:
        void slotHide();
        void slotShowHelp();
        void slotResetPause();

    private:
        TQString path;
        int current;
        TQPixmap pixmap;
        TQColor bgcolor, tcolor;
        TQTimer *timerHide;
        TQLabel *message;
        TQHBox *options;
        bool messages, mes_name, mes_size, mes_pos;
        int total;
        TQToolButton *buttonPause;

        static SQ_SlideShowWidget *m_inst;
};

#endif
