/***************************************************************************
                           Backtracelistview.h
                         ------------------------
    begin                : 2005-07-31
    copyright            : (C) 2005 Linus McCabe

 ***************************************************************************/

/****************************************************************************
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 ***************************************************************************/


#ifndef BACKTRACELISTVIEW_H
#define BACKTRACELISTVIEW_H

#include <tdelistview.h>
#include <tdepopupmenu.h>
#include <tqptrlist.h>

class BacktraceListview;


enum BacktraceType
{
  File = 0,
  Eval
};


class BacktraceListviewItem : public TDEListViewItem
{
  private:
    BacktraceType m_type;
    TQString m_filename;
    TQString m_func;
    long m_line;
    long m_level;

  public:
    BacktraceListviewItem();
    BacktraceListviewItem(BacktraceListview* view);

    // Type
    BacktraceType type() const { return m_type; }
    void setType(BacktraceType type) { m_type = type; }

    // Filename
    TQString filename() const { return m_filename; }
    void setFilename(const TQString &filename) { m_filename = filename; }
    
    // Function
    TQString func() const { return m_func; }
    void setFunc(const TQString &func) { m_func = func; }
    
    // Line
    long line() const { return m_line; }
    void setLine(long line) { m_line= line; }
    
    // Level
    long level() const { return m_level; }
    void setLevel(long level) { m_level = level; }

};

class BacktraceListview : public TDEListView
{
  Q_OBJECT
  

  public:

    BacktraceListview(TQWidget *parent = 0, const char *name = 0);
    ~BacktraceListview();

    void backtraceShow(int level, BacktraceType type, const TQString& filename, long line, const TQString& func);

    void clear();

  public slots:
    void slotBacktraceDoubleClick(TQListViewItem *item, const TQPoint &point, int column);

  private:
    void keyPressEvent(TQKeyEvent *e);
    void jumpHistory(TQListViewItem *item);

};

#endif
