/***************************************************************************
                         dialog.cpp - Main dialog widget 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef KMDR_EXECUTOR_PATH
#define KMDR_EXECUTOR_PATH "/usr/bin/kmdr-executor"
#endif

/* KDE INCLUDES */
#include <tdelocale.h>

/* QT INCLUDES */
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>
#include <tqdialog.h>
#include <tqpoint.h>
#include <tqcursor.h>
#include <tqapplication.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "dialog.h"
#include <myprocess.h>
#include "kommanderplugin.h"

enum Functions {
  FirstFunction = 185,
  D_focusWidget,
  D_waitCursor,
  D_restoreCursor,
  LastFunction
};

Dialog::Dialog(TQWidget *a_parent, const char *a_name, bool a_modal, int a_flags)
  : TQDialog(a_parent, a_name, a_modal, a_flags), KommanderWindow(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  states << "initialization";
  states << "destroy";
  setStates(states);
  setDisplayStates(states);
  m_useShebang = false;
  m_shebang = "#!" KMDR_EXECUTOR_PATH;
  m_firstShow = true;
  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(D_focusWidget, "focusWidget(TQString widget)",  i18n("The name of the widget having focus"), 1);
  KommanderPlugin::registerFunction(D_waitCursor, "waitCursor(TQString widget)",  i18n("Set a wait cursor. CAUTION: if set more than once an equal number of calls to restore must be made to clear it."), 1);
  KommanderPlugin::registerFunction(D_restoreCursor, "restoreCursor(TQString widget)",  i18n("Restore normal curser. NOTE: must be called as many times as wait was."), 1);
}

Dialog::~Dialog()
{
  if (!inEditor)
    destroy();
}

TQString Dialog::currentState() const
{
  return TQString("default");
}

bool Dialog::isKommanderWidget() const
{
  return true;
}

bool Dialog::useInternalParser() const
{
  return m_useInternalParser; 
}

void Dialog::setUseInternalParser(bool b) 
{
  KommanderWidget::useInternalParser = b; 
  m_useInternalParser = b;
}


TQStringList Dialog::associatedText() const
{
  return KommanderWidget::associatedText();
}

void Dialog::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void Dialog::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText( a_text );
}

TQString Dialog::populationText() const
{
  return KommanderWidget::populationText();
}

void Dialog::populate()
{
  setWidgetText(KommanderWidget::evalAssociatedText(populationText()));
}

void Dialog::initialize()
{    
  const TQStringList assoc = associatedText();
  if (assoc.count() > 1 && !assoc[1].isEmpty()) 
  {
    MyProcess proc(this);
    proc.run( KommanderWidget::evalAssociatedText(assoc[1]) );
  }
}

void Dialog::destroy()
{    
  const TQStringList assoc = associatedText();
  if (assoc.count() > 2 && !assoc[2].isEmpty()) 
  {
    MyProcess proc(this);
    proc.run( KommanderWidget::evalAssociatedText(assoc[2]) );
  }
}


void Dialog::setWidgetText(const TQString& a_text)
{
  setCaption(a_text);
  emit widgetTextChanged(a_text);
}

void Dialog::exec()
{
  TQDialog::exec();
  emit finished();
}

void Dialog::show()
{
//if the dialog is embedded in a KPart, the show can be called many times.
//to avoid re-init and sending signals we don't want, in that case call only the
//TQWidget's show method to show the widgets, but don't do any TQDialog specific 
//task
  if (!m_firstShow) 
  {
    TQWidget::show();
  } else
  {
    TQDialog::show();
    if (!inEditor)
      initialize();
    m_firstShow = false;
  }
}

void Dialog::done(int r)
{
/*  if (!inEditor)
    destroy();*/
  TQDialog::done(r);  
}

void Dialog::showEvent(TQShowEvent *e)
{
  TQDialog::showEvent( e );
  emit widgetOpened();
}

void Dialog::keyPressEvent( TQKeyEvent *e )
{
  if ( e->state() == 0 && e->key() == Key_Escape)
	return;
  else
   TQDialog::keyPressEvent(e);
  
}

void Dialog::contextMenuEvent( TQContextMenuEvent * e )
{
  TQDialog::contextMenuEvent( e );
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

bool Dialog::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::geometry || (f > FirstFunction && f < LastFunction);
}

TQString Dialog::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return caption();
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::geometry:
      return TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      break;
    case D_focusWidget:
      return focusWidget()->name();
      break;
    case D_waitCursor:
      TQApplication::setOverrideCursor(TQCursor(TQt::WaitCursor));
      break;
    case D_restoreCursor:
      TQApplication::restoreOverrideCursor();
      break;
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}


#include "dialog.moc"
