/*
 *  This file is part of the KDE project
 *  Copyright (C) 2002 Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2.0 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  $Id$
 */

#include "sidebarwidget.h"
#include <tqscrollview.h>
#include <tqlayout.h>
#include <tqvbox.h>
#include <ksettings/dialog.h>
#include <ksettings/dispatcher.h>
#include <kcmultidialog.h>

#include <kiconloader.h>
#include <tdetoolbar.h>
#include <tdeaction.h>
#include <tdelocale.h>
#include <dcopref.h>

sidebarwidget::sidebarwidget(TQWidget* parent, const char* name)
    : TQWidget(parent,name), settingsDialog(0)
{
    mainLayout = new TQVBoxLayout(this);

    TDEToolBar *toolbar = new TDEToolBar(this);
    toolbar->setLabel( i18n("Weather Sidebar") );
    toolbar->setSizePolicy(TQSizePolicy::Maximum, TQSizePolicy::Minimum);

    TDEAction *refresh = new TDEAction( i18n("Refresh"), SmallIcon("view-refresh"),
        0, TQT_TQOBJECT(this), TQT_SLOT(slotRefresh()), this, "refresh" );
    TDEAction *prefs   = new TDEAction( i18n("Settings"), SmallIcon("configure"),
        0, TQT_TQOBJECT(this), TQT_SLOT(slotConfigure()), this, "preferences" );
    refresh->plug(toolbar);
    prefs->plug(toolbar);

    reportGrid = new TQScrollView(this);
    reportGrid->setResizePolicy(TQScrollView::AutoOneFit);

    layout = new TQVBoxLayout(reportGrid->viewport());
    view = new TQVBox(reportGrid->viewport());
    view->setSpacing(3);
    layout->addWidget(view);
    layout->addStretch();

    mainLayout->addWidget(toolbar);
    mainLayout->addWidget(reportGrid);

    dcopCall = new DCOPRef( "KWeatherService", "WeatherService" );
}

sidebarwidget::~sidebarwidget()
{
}

TQWidget *sidebarwidget::viewport()
{
    return view;
}

void sidebarwidget::slotRefresh()
{
    dcopCall->send("updateAll()");
}

void sidebarwidget::slotConfigure()
{
    if ( settingsDialog == 0 )
    {
      settingsDialog = new KCMultiDialog(0);
      connect( settingsDialog, TQT_SIGNAL( configCommitted() ), this, TQT_SLOT( slotRefresh() ) );

      settingsDialog->addModule( "kcmweatherservice.desktop" );
    }

    settingsDialog->show();
    settingsDialog->raise();
}

#include "sidebarwidget.moc"
