/***************************************************************************
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "addtranslationdlg.h"

#include <tqcombobox.h>
#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqstrlist.h>
#include <kbuttonbox.h>
#include <kdialog.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kstdguiitem.h>
#include <tdeversion.h>

#include "misc.h"
#include "autoprojectpart.h"


AddTranslationDialog::AddTranslationDialog(AutoProjectPart *part, TQWidget *parent, const char *name)
    : TQDialog(parent, name, true)
{
    setCaption(i18n("Add Translation"));

    m_part = part;

    TQHBox *hbox = new TQHBox(this);
    (void) new TQLabel(i18n("Language:"), hbox);
    lang_combo = new TQComboBox(hbox);

    TQVBoxLayout *layout = new TQVBoxLayout(this, KDialog::marginHint(), KDialog::spacingHint());
    layout->addWidget(hbox);

    TQFrame *frame = new TQFrame(this);
    frame->setFrameStyle(TQFrame::HLine | TQFrame::Sunken);
    layout->addWidget(frame, 0);

    KButtonBox *buttonbox = new KButtonBox(this);
    buttonbox->addStretch();
    TQPushButton *ok_button = buttonbox->addButton(KStdGuiItem::ok());
    TQPushButton *cancel_button = buttonbox->addButton(KStdGuiItem::cancel());
    ok_button->setDefault(true);
    connect( ok_button, TQT_SIGNAL(clicked()), this, TQT_SLOT(accept()) );
    connect( cancel_button, TQT_SIGNAL(clicked()), this, TQT_SLOT(reject()) );
    buttonbox->layout();
    layout->addWidget(buttonbox, 0);

    TQStringList rawlist, list;
    rawlist << "af" << "ar" << "bg" << "bo" << "br" << "bs" << "ca" << "cs" << "cy" << "da"
            << "de" << "el" << "en_GB"   << "eo" << "es" << "et" << "eu" << "fi" << "fr";
    rawlist << "ga" << "gl" << "gu" << "he" << "hi" << "hu" << "id" << "is" << "it" << "ja"
            << "km" << "ko" << "lt" << "lv" << "mi" << "mk" << "mr" << "nl" << "no" << "no_NY";
    rawlist << "oc" << "pl" << "pt" << "pt_BR" << "ro" << "ru" << "sk" << "sl" << "sr" << "sv"
            << "ta" << "th" << "tr" << "uk" << "wa" << "zh_CN.GB2312" << "zh_TW.Big5";

    // Remove already added languages
    TQStringList::ConstIterator it;
    for (it = rawlist.begin(); it != rawlist.end(); ++it) {
        TQFileInfo fi(m_part->projectDirectory() + "/po/" + (*it) + ".po");
        if (!fi.exists())
            list.append(*it);
    }

    if (list.isEmpty()) {
        KMessageBox::information(this, i18n("Your sourcecode is already translated to all supported languages."));
        ok_button->setEnabled(false);
    }
    lang_combo->insertStringList(list);
}


AddTranslationDialog::~AddTranslationDialog()
{}


void AddTranslationDialog::accept()
{
    TQString dir = m_part->projectDirectory() + "/po";
    TQString fileName = dir + "/" + lang_combo->currentText() + ".po";

    TQFile f(fileName);
    if (f.exists()) {
        KMessageBox::information(this, i18n("A translation file for the language %1 exists already."));
        return;
    }
    f.open(IO_WriteOnly);
    f.close();

    dir = m_part->buildDirectory() + "/po";
    m_part->startMakeCommand(dir, TQString::fromLatin1("force-reedit"));

    TQDialog::accept();
}

#include "addtranslationdlg.moc"
