#include "main.h"
#include "main.moc"

#include <tdeaction.h>
#include <kstdaction.h>
#include <tdemenubar.h>
#include <kstdgameaction.h>
#include <kcmenumngr.h>
#include <kkeydialog.h>
#include <tdelocale.h>
#include <knotifyclient.h>
#include <knotifydialog.h>
#include <highscore/kexthighscore.h>
#include <tdeconfigdialog.h>

#include "inter.h"
#include "factory.h"
#include "settings.h"
#include "baseprefs.h"

BaseMainWindow::BaseMainWindow()
  : KZoomMainWindow(4, 100, 1, "main_window")
{
    KNotifyClient::startDaemon();

    // File & Popup
    KStdGameAction::gameNew(TQT_TQOBJECT(this), TQT_SLOT(start()), actionCollection());
    _pause = KStdGameAction::pause(TQT_TQOBJECT(this), TQT_SLOT(pause()), actionCollection());
    _pause->setEnabled(false);
    KStdGameAction::highscores(TQT_TQOBJECT(this), TQT_SLOT(showHighscores()),
                               actionCollection());
    KStdGameAction::quit(TQT_TQOBJECT(tqApp), TQT_SLOT(quit()), actionCollection());

    // Settings
    KStdAction::preferences(TQT_TQOBJECT(this), TQT_SLOT(configureSettings()),
                            actionCollection());
    KStdAction::keyBindings(TQT_TQOBJECT(this), TQT_SLOT(configureKeys()), actionCollection());
    KStdAction::configureNotifications(TQT_TQOBJECT(this), TQT_SLOT(configureNotifications()),
                                       actionCollection());
    KStdGameAction::configureHighscores(TQT_TQOBJECT(this), TQT_SLOT(configureHighscores()),
                                        actionCollection());

    _inter = bfactory->createInterface(this);
}

void BaseMainWindow::buildGUI(TQWidget *widget)
{
    createGUI();
    setCentralWidget(widget);
    init("popup");
}

BaseMainWindow::~BaseMainWindow()
{
    delete _inter;
}

void BaseMainWindow::showHighscores()
{
    _inter->showHighscores(this);
}

void BaseMainWindow::start()
{
    _inter->_start();
}

void BaseMainWindow::pause()
{
    _inter->_pause();
}

void BaseMainWindow::configureHighscores()
{
    KExtHighscore::configure(this);
}

void BaseMainWindow::configureSettings()
{
    if ( !_inter->_isPaused() ) _inter->_pause();
    if ( TDEConfigDialog::showDialog("settings") ) return;

    TDEConfigDialog *dialog = new TDEConfigDialog(this, "settings", BasePrefs::self() );
    TQWidget *w = bfactory->createGameConfig();
    if (w) dialog->addPage(w, i18n("Game"), "package_system");
    w = bfactory->createAppearanceConfig();
    if (w) dialog->addPage(w, i18n("Appearance"), "style");
    w = bfactory->createColorConfig();
    if (w) dialog->addPage(w, i18n("Colors"), "colorize");
//    dialog->addPage(new BackgroundConfigWidget, i18n("Background"), "background");
    addConfig(dialog);
    connect(dialog, TQT_SIGNAL(settingsChanged()), TQT_SIGNAL(settingsChanged()));
    dialog->show();
}

void BaseMainWindow::configureKeys()
{
    KKeyDialog d(true, this);
    addKeys(d);
    d.insert(actionCollection());
    d.configure(false);
    actionCollection()->writeShortcutSettings();
    saveKeys();
}

void BaseMainWindow::configureNotifications()
{
    KNotifyDialog::configure(this);
}

void BaseMainWindow::writeZoomSetting(uint zoom)
{
  BasePrefs::setBlockSize(zoom);
  BasePrefs::writeConfig();
}

uint BaseMainWindow::readZoomSetting() const
{
  return BasePrefs::blockSize();
}

void BaseMainWindow::writeMenubarVisibleSetting(bool visible)
{
  BasePrefs::setMenubarVisible(visible);
  BasePrefs::writeConfig();
}

bool BaseMainWindow::menubarVisibleSetting() const
{
  return BasePrefs::menubarVisible();
}
