//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQPixmap;
import org.trinitydesktop.qt.TQPaintEvent;
import org.trinitydesktop.qt.TQPoint;
import org.trinitydesktop.qt.TQMouseEvent;
import org.trinitydesktop.qt.TQEvent;
import org.trinitydesktop.qt.TQWidget;
import org.trinitydesktop.qt.TQWidget;

/**

 Floatable widget that can be dragged around with the mouse and
 encapsulate the actual widgets (and member of the dockwidget class
 set).
 You just grip the double-lined panel, tear it off its parent
 widget, drag it somewhere and let it loose. Depending on the
 position where you leave it, the dockwidget becomes a toplevel
 window on the desktop (floating mode) or docks to a new widget
 (dock mode). Note: A KDockWidget can only be docked to a
 KDockWidget.
 If you want to use this kind of widget, your main application
 window has to be a KDockMainWindow.  That is because it has
 got several additional dock management features, for instance a
 KDockManager that has an overview over all dockwidgets and and
 a dockmovemanager (internal class) that handles the dock process.
 Usually you create an KDockWidget that covers the actual widget in this way:
 <pre>
 ...
 KDockMainWindow mainWidget;
 ...
 KDockWidget dock = null;
 dock = mainWidget.createDockWidget( "Any window caption", nicePixmap, null, i18n("window caption")); // null==no parent
 TQWidget actualWidget = new TQWidget( dock);
 dock.setWidget( actualWidget); // embed it
 dock.setToolTipString(i18n("That's me")); // available when appearing as tab page
 ...
 </pre>
 See KDockMainWindow how a dockwidget is docked in.
 See {@link KDockWidgetSignals} for signals emitted by KDockWidget
		@author Max Judin (documentation: Falk Brettschneider).

		@short    Floatable widget that can be dragged around with the mouse and  encapsulate the actual widgets (and member of the dockwidget class  set).

*/
public class KDockWidget extends TQWidget  {
	protected KDockWidget(Class dummy){super((Class) null);}
	/**
		 The possible positions where a dockwidget can dock to another dockwidget
		   		@short    The possible positions where a dockwidget can dock to another dockwidget
	*/
	public static final int DockNone = 0;
	public static final int DockTop = 0x0001;
	public static final int DockLeft = 0x0002;
	public static final int DockRight = 0x0004;
	public static final int DockBottom = 0x0008;
	public static final int DockCenter = 0x0010;
	public static final int DockDesktop = 0x0020;
	public static final int DockToSpecialSites = 0x0040;
	public static final int DockCorner = DockTop|DockLeft|DockRight|DockBottom;
	public static final int DockFullSite = DockCorner|DockCenter;
	public static final int DockFullDocking = DockFullSite|DockDesktop;

	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Construct a dockwidget.
			 Initially, docking to another and docking to this is allowed for
		 every <code>DockPosition.</code>  It is supposed to be no (tab) group. It will
		 taken under control of its dockmanager.
			@param dockManager The responsible manager (dock helper)
			@param name Object instance name
			@param pixmap An icon (for instance shown when docked centered)
			@param parent Parent widget
			@param strCaption Title of the dockwidget window (shown when toplevel)
			@param strTabPageLabel The title of the tab page (shown when in tab page mode), if it is "", only the icon will be shown, if it is null, the label is set to strCaption
			@param f Qt.WidgetFlags widget flags
		   		@short    Construct a dockwidget.
	*/
	public KDockWidget(KDockManager dockManager, String name, TQPixmap pixmap, TQWidget parent, String strCaption, String strTabPageLabel, int f) {
		super((Class) null);
		newKDockWidget(dockManager,name,pixmap,parent,strCaption,strTabPageLabel,f);
	}
	private native void newKDockWidget(KDockManager dockManager, String name, TQPixmap pixmap, TQWidget parent, String strCaption, String strTabPageLabel, int f);
	public KDockWidget(KDockManager dockManager, String name, TQPixmap pixmap, TQWidget parent, String strCaption, String strTabPageLabel) {
		super((Class) null);
		newKDockWidget(dockManager,name,pixmap,parent,strCaption,strTabPageLabel);
	}
	private native void newKDockWidget(KDockManager dockManager, String name, TQPixmap pixmap, TQWidget parent, String strCaption, String strTabPageLabel);
	public KDockWidget(KDockManager dockManager, String name, TQPixmap pixmap, TQWidget parent, String strCaption) {
		super((Class) null);
		newKDockWidget(dockManager,name,pixmap,parent,strCaption);
	}
	private native void newKDockWidget(KDockManager dockManager, String name, TQPixmap pixmap, TQWidget parent, String strCaption);
	public KDockWidget(KDockManager dockManager, String name, TQPixmap pixmap, TQWidget parent) {
		super((Class) null);
		newKDockWidget(dockManager,name,pixmap,parent);
	}
	private native void newKDockWidget(KDockManager dockManager, String name, TQPixmap pixmap, TQWidget parent);
	public KDockWidget(KDockManager dockManager, String name, TQPixmap pixmap) {
		super((Class) null);
		newKDockWidget(dockManager,name,pixmap);
	}
	private native void newKDockWidget(KDockManager dockManager, String name, TQPixmap pixmap);
	/**
		 This is a key method of this class! Use it to dock dockwidgets to
		 another dockwidget at the right position within its
		 KDockMainWindow or a toplevel dockwidget.
			 If the target is null, it will become a toplevel dockwidget at position pos;
		 Note: Docking to another dockwidget means exactly:
		 A new parent dockwidget will be created, that replaces the target dockwidget and contains another single helper widget (tab widget or panner)
		 which contains both dockwidgets, this and the target dockwidget. So consider parent<.child relationships change completely during such actions.
			@param target The dockwidget to dock to
			@param dockPos One of the DockPositions this is going to dock to
			@param spliPos The split relation (in percent, or percent*100 in high resolution) between both dockwidgets, target and this
			@param pos The dock position, mainly of interest for docking to the desktop (as toplevel dockwidget)
			@param check Only for internal use;
			@param tabIndex The position index of the tab widget (when in tab page mode), -1 (default) means append
			 @note Since KDE 3.5 the splitter position <code>spliPos</code> is always a value between [0..100]. If
		       the value is > 100, it will be treated like the old code and normalized to a value between
		       0 and 100. Example: If the value was 4000, it will be fixed to 40. In short: The old and
		       the new behavior both work, so it is compatible with older KDE-versions.
		   		@return result The group dockwidget that replaces the target dockwidget and will be grandparent of target and <code>this.</code>

		@short    This is a key method of this class! Use it to dock dockwidgets to  another dockwidget at the right position within its  KDockMainWindow or a toplevel dockwidget.
	*/
	public native KDockWidget manualDock(KDockWidget target, int dockPos, int spliPos, TQPoint pos, boolean check, int tabIndex);
	public native KDockWidget manualDock(KDockWidget target, int dockPos, int spliPos, TQPoint pos, boolean check);
	public native KDockWidget manualDock(KDockWidget target, int dockPos, int spliPos, TQPoint pos);
	public native KDockWidget manualDock(KDockWidget target, int dockPos, int spliPos);
	public native KDockWidget manualDock(KDockWidget target, int dockPos);
	/**
		 Specify where it is either possible or impossible for this to dock to another dockwidget.
			@param pos An OR'ed set of <code>DockPositions</code>
		   		@short    Specify where it is either possible or impossible for this to dock to another dockwidget.
	*/
	public native void setEnableDocking(int pos);
	/**
				@return Where it is either possible or impossible for this to dock to another dockwidget (an OR'ed set of DockPositions).

		@short
	*/
	public native int enableDocking();
	/**
		 Specify where it is either possible or impossible for another dockwidget to dock to this.
			@param pos An OR'ed set of <code>DockPositions</code>
		   		@short    Specify where it is either possible or impossible for another dockwidget to dock to this.
	*/
	public native void setDockSite(int pos);
	/**
				@return There it is either possible or impossible for another dockwidget to dock to this (an OR'ed set of <code>DockPositions</code>).

		@short
	*/
	public native int dockSite();
	/**
		 Sets the embedded widget.
			 A TQLayout takes care about proper resizing, automatically.
			@param w The pointer to the dockwidget's child widget.
		   		@short    Sets the embedded widget.
	*/
	public native void setWidget(TQWidget w);
	/**
		 Get the embedded widget.
				@return The pointer to the dockwidget's child widget, 0L if there's no such child.

		@short    Get the embedded widget.
	*/
	public native TQWidget getWidget();
	/**
		 Sets the header of this dockwidget.
			 A TQLayout takes care about proper resizing, automatically.
		 The header contains the drag panel, the close button and the stay button.
			@param ah A base class pointer to the dockwidget header
		   		@short    Sets the header of this dockwidget.
	*/
	public native void setHeader(KDockWidgetAbstractHeader ah);
	/**	@since 3.2
		 get the pointer to the header widget
		   		@short  @since 3.
	*/
	public native KDockWidgetAbstractHeader getHeader();
	/**
		 Normally it simply shows the dockwidget.
			 But additionally, if it is docked to a tab widget (<code>DockCenter</code>), it is set as the active (visible) tab page.
		   		@short    Normally it simply shows the dockwidget.
	*/
	public native void makeDockVisible();
	/**
			 There are reasons that it's impossible:

			<li>
			It is a (tab) group.
			</li>

			<li>
			It is already invisible ;-)
			</li>

			<li>
			The parent of this is the KDockMainWindow.
			</li>

			<li>
			It isn't able to dock to another widget.

			</li>		@return If it may be possible to hide this.

		@short
	*/
	public native boolean mayBeHide();
	/**

			<li>
			It is a (tab) group.
			</li>

			<li>
			It is already visible ;-)
			</li>

			<li>
			The parent of this is the <code>KDockMainWindow.</code>

			</li>		@return If it may be possible to show this.
 There are reasons that it's impossible:

		@short
	*/
	public native boolean mayBeShow();
	/**
				@return The dockmanager that is responsible for this.

		@short
	*/
	public native KDockManager dockManager();
	/**
		 Stores a string for a tooltip.
			 That tooltip string has only a meaning when this dockwidget is shown as tab page.
		 In this case the tooltip is shown when one holds the mouse cursor on the tab page header.
		 Such tooltip will for instance be useful, if you use only icons there.
		 Note: Setting an empty string switches the tooltip off.
			@param ttStr A string for the tooltip on the tab.
		   		@short    Stores a string for a tooltip.
	*/
	public native void setToolTipString(String ttStr);
	/**
				@return The tooltip string being shown on the appropriate tab page header when in dock-centered mode.

		@short
	*/
	public native String toolTipString();
	/**
				@return result <code>true</code>, if a dockback is possible, otherwise <code>false.</code>

		@short
	*/
	public native boolean isDockBackPossible();
	/**
		 Sets a string that is used for the label of the tab page when in tab page mode
			@param label The new tab page label.
		   		@short    Sets a string that is used for the label of the tab page when in tab page mode
	*/
	public native void setTabPageLabel(String label);
	/**
				@return A string that is used for the label of the tab page when in tab page mode.

		@short
	*/
	public native String tabPageLabel();
	/**
		 Catches and processes some TQWidget events that are interesting for dockwidgets.
		   		@short    Catches and processes some TQWidget events that are interesting for dockwidgets.
	*/
	public native boolean event(TQEvent arg1);
	/**
		 Add dockwidget management actions to TQWidget.show.
		   		@short    Add dockwidget management actions to TQWidget.show.
	*/
	public native void show();
	/**
				@return the parent widget of this if it inherits class KDockTabGroup

		@short
	*/
	public native KDockTabGroup parentDockTabGroup();
	public native TQWidget parentDockContainer();
	/**
		 Sets the type of the dock window
			@param windowType is type of dock window
		   		@short    Sets the type of the dock window
	*/
	public native void setDockWindowType(int windowType);
	public native void setDockWindowTransient(TQWidget parent, boolean transientEnabled);
	/**
		 Returns the widget this dockwidget is set transient to, otherwise 0
				@short    Returns the widget this dockwidget is set transient to, otherwise 0
	*/
	public native TQWidget transientTo();
	/**
		 Lookup the nearest dockwidget docked left/right/top/bottom to this one or return 0
			@param pos is the position the wanted widget is docked to this one
				@short    Lookup the nearest dockwidget docked left/right/top/bottom to this one or return 0
	*/
	public native KDockWidget findNearestDockWidget(int pos);
	/**
		 Allows changing the pixmap which is used for the caption or dock tabs
			@param pixmap is the pixmap to set
				@short    Allows changing the pixmap which is used for the caption or dock tabs
	*/
	public native void setPixmap(TQPixmap pixmap);
	public native void setPixmap();
	/**
		 Returns the dockwidget's associated caption/dock tab pixmap
				@short    Returns the dockwidget's associated caption/dock tab pixmap
	*/
	public native TQPixmap pixmap();
	/**
				@return the current dock position.

		@short
	*/
	public native int currentDockPosition();
	/**
		 subject to changes. It doesn't completely work yet without small hacks from within the calling application (Perhaps
		 KDE 3.1.x oder 3.2
		 width is in pixel. It only affects a widget, which is placed directly into a horizontal KDockSplitter
				@short    subject to changes.
	*/
	public native void setForcedFixedWidth(int arg1);
	/**
		 subject to changes. It doesn't completely work yet without small hacks from within the calling application (Perhaps
		 KDE 3.1.x oder 3.2
		 height is in pixel. It only affects a widget, which is placed directly into a vertical KDockSplitter
				@short    subject to changes.
	*/
	public native void setForcedFixedHeight(int arg1);
	public native void restoreFromForcedFixedSize();
	public native int forcedFixedWidth();
	public native int forcedFixedHeight();
	/**
		 Docks a dockwidget back to the dockwidget that was the neighbor
		   widget before the current dock position.
		  		@short    Docks a dockwidget back to the dockwidget that was the neighbor    widget before the current dock position.
	*/
	public native void dockBack();
	/**
		 Toggles the visibility state of the dockwidget if it is able to be shown or to be hidden.
		   		@short    Toggles the visibility state of the dockwidget if it is able to be shown or to be hidden.
	*/
	public native void changeHideShowState();
	/**
		 Undocks this. It means it becomes a toplevel widget framed by the system window manager.
		 A small panel at the top of this undocked widget gives the possibility to drag it into
		 another dockwidget by mouse (docking).
		   		@short    Undocks this.
	*/
	public native void undock();
	/**
		 Docks the widget to the desktop (as a toplevel widget)
				@short    Docks the widget to the desktop (as a toplevel widget)
	*/
	public native void toDesktop();
	/**
		 Checks some conditions and shows or hides the dockwidget header (drag panel).
		 The header is hidden if:

			<li>
			the parent widget is the KDockMainWindow
			</li>

			<li>
			this is a (tab) group dockwidget
			</li>

			<li>
			it is not able to dock to another dockwidget

			</li>		@short    Checks some conditions and shows or hides the dockwidget header (drag panel).
	*/
	protected native void updateHeader();
	protected native void setLatestKDockContainer(TQWidget arg1);
	protected native TQWidget latestKDockContainer();
	protected native void setFormerBrotherDockWidget(KDockWidget arg1);
	/**	 Does several things here when it has noticed that the former brother widget (closest neighbor) gets lost.
		 The former brother widget is needed for a possible dockback action, to speak with the Beatles:
		 "To get back to where you once belonged" ;-)
		   		@short   Does several things here when it has noticed that the former brother widget (closest neighbor) gets lost.
	*/
	protected native void loseFormerBrotherDockWidget();
	protected native void paintEvent(TQPaintEvent arg1);
	protected native void mousePressEvent(TQMouseEvent arg1);
	protected native void mouseReleaseEvent(TQMouseEvent arg1);
	protected native void mouseMoveEvent(TQMouseEvent arg1);
	protected native void leaveEvent(TQEvent arg1);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
