#!/usr/bin/env python

type_list = ['KURL', 'TQDate', 'TQTime', 'TQDateTime', 'TQRect', 'TQString', 'int', 'TQFont', 'TQSize', 'TQPoint', 'TQPointArray' ]

inc_exceptions = {'TQDate': None, 'TQTime': None, 'KURL' : 'kurl'}

iface_inc_list = ['dcopobject']

iface_inc_list += [ t.lower() for t in type_list if t[0]=='Q' and t not in inc_exceptions ]
iface_inc_list += inc_exceptions.values()

iface_inc_1 = ['class DCOPDemoIface : virtual public DCOPObject {',
             '   K_DCOP',
             '   k_dcop:']
h_inc = []
cpp_inc = []

for t in type_list:
    iface_inc_1.append("virtual void set%sVal(const %s &val) = 0; " % (t,t) )
    iface_inc_1.append("virtual %s %sVal() const = 0;" % (t,t) )

    h_inc.append("virtual void set%sVal(const %s &val); " % (t,t) )
    h_inc.append("virtual %s %sVal() const;" % (t,t) )
    h_inc.append("%s m_%sValue;" % (t,t) )

    cpp_inc.append("void MainClass::set%sVal(const %s & val) {" % (t,t) )
    cpp_inc.append("  m_%sValue = val; }" % t)
    cpp_inc.append("%s MainClass::%sVal() const {" % (t,t) )
    cpp_inc.append("  return m_%sValue; }" % t)

iface_inc = []
for inc in iface_inc_list:
    if inc: iface_inc.append("#include <%s.h>" % inc)
iface_inc += iface_inc_1
iface_inc.append("};")

files = {'tdedcoptest_iface.h': iface_inc,
         'h_inc.h': h_inc,
         'cpp_inc.h': cpp_inc
         }

for (fname,data) in files.items():
    outf = file(fname,'w')
    for d in data:
        outf.write(d+'\n')
    outf.close()
