/*
    AddressBookSelectorDialog
    Nice Dialog to select a KDE AddressBook contact

    Copyright (c) 2005 by Duncan Mac-Vicar Prett <duncan@kde.org>

    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "addressbookselectordialog.h"
#include "addressbookselectorwidget.h"
#include <kdialogbase.h>
#include <tqdialog.h>
#include <tqlistview.h>
#include <tqvbox.h>
#include <tdelocale.h>
#include <kdialog.h>

namespace Kopete
{
namespace UI
{

AddressBookSelectorDialog::AddressBookSelectorDialog(const TQString &title, const TQString &message, const TQString &preSelectUid, TQWidget *parent, const char *name, bool modal ) : KDialogBase(parent, name, modal, title, Help|Ok|Cancel, Ok, true )
{
	TQVBox *vbox=new TQVBox(this);
	m_addressBookSelectorWidget= new AddressBookSelectorWidget(vbox);
	m_addressBookSelectorWidget->setLabelMessage(message);	

	vbox->setSpacing( KDialog::spacingHint() );
	
	setMainWidget(vbox);
	enableButtonOK(false);
	//setHelp("linkaddressbook");

	connect(m_addressBookSelectorWidget, TQT_SIGNAL(addresseeListClicked( TQListViewItem * )), TQT_SLOT(slotWidgetAddresseeListClicked( TQListViewItem * )));

	if ( !preSelectUid.isEmpty() )
		m_addressBookSelectorWidget->selectAddressee(preSelectUid);
}

AddressBookSelectorDialog::~AddressBookSelectorDialog()
{
}

TDEABC::Addressee AddressBookSelectorDialog::getAddressee( const TQString &title, const TQString &message, const TQString &preSelectUid, TQWidget *parent)
{
	AddressBookSelectorDialog dialog(title, message, preSelectUid, parent);
	int result = dialog.exec();

	TDEABC::Addressee adr;
	if ( result == TQDialog::Accepted )
		adr = dialog.addressBookSelectorWidget()->addressee();

	return adr;
}

void AddressBookSelectorDialog::slotWidgetAddresseeListClicked( TQListViewItem *addressee )
{
	// enable ok if a valid addressee is selected
	enableButtonOK( addressee ? addressee->isSelected() : false);
}

void AddressBookSelectorDialog::accept()
{
	TQDialog::accept();
}

void AddressBookSelectorDialog::reject()
{
	TQDialog::reject();
}

} // namespace UI
} // namespace Kopete

#include "addressbookselectordialog.moc"
