#!/bin/bash

PKGNAME="${1##*/}"
TDE_VERSION="${2:-${TDE_VERSION:-14.0.10}}"
DIST="$3"

[ -z "${PKGNAME}" ] && echo "You must specify a package name !" && exit 1
SPECFILE=$(get_specfile.sh ${PKGNAME} ${TDE_VERSION})
SPECDIR="${SPECFILE%/*}"
RPMPKGNAME="$(get_rpm_package_name.sh ${PKGNAME})"

[ ! -r "${SPECFILE}" ] && exit 2

while read var val; do
  case "${var}" in
    Version:*) VERSION="${val}";;
    Source[0-9]*:|Source:|Patch[0-9]*:)
      FILE="${SPECDIR}/${val##*/}"
      if [ "${DIST}" = "any" ] && [ "${var//%\{?dist\}/}" = "${var}" ]; then
        FILES="${FILE//%\{?dist\}/.}"*
      else
        FILES="${FILE}"
      fi

      for FILE in $FILES; do
        file=$(rpm --define "tde_pkg ${PKGNAME}" \
                   --define "tde_version ${TDE_VERSION}" \
                   --define "name ${RPMPKGNAME}" \
                   --define "version ${VERSION}" \
                   --define "dist ${DIST:-$(rpm -E %dist)}" \
                   -E "${FILE}")
        [ -r "${file}" ] && echo "${file}"
      done
    ;;
  esac
done < "${SPECFILE}"
