"""
This program tests/demos some of the TDESharedPtr related classes and
methods (KMimeType, KService, etc). It generally tests the *::List
methods for these classes (eg KService::List) since that also tests
the *::Ptr mapped type code (eg KService::Ptr) at the same time.

This version is suitable for KDE >= 3.0.0 (some methods not available
in earlier versions)
"""

"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

import sys

from python_tqt.qt import TQWidget, TQButtonGroup, TQt, TQLabel, TQListView, TQListViewItem

from tdecore import TDEApplication, TDECmdLineArgs, TDEAboutData, KURL
from tdeui import TDEMainWindow, KTabCtl, TDEListBox
from tdeio import KMimeType, KService, KServiceGroup, KServiceType, TDETrader, KServiceTypeProfile, KServiceGroup

class MainWin (TDEMainWindow):
    def __init__ (self, *args):
        apply (TDEMainWindow.__init__, (self,) + args)

        tabctl = KTabCtl (self)
        self.setGeometry (0, 0, 600, 400)
        tabctl.setGeometry (10, 10, 550, 380)

        tabctl.addTab (KMimeTypeTab (tabctl), "KMimeType")
        tabctl.addTab (KServiceTab (tabctl), "KService")
        tabctl.addTab (KSycocaEntryTab (tabctl), "KSycocaEntry")
        tabctl.addTab (KServiceTypeTab (tabctl), "KServiceType")
        tabctl.addTab (OfferListTab (tabctl), "OfferList")

        tabctl.show ()


class OfferListTab (TQWidget):
    def __init__ (self, parent, name = ""):
        TQWidget.__init__ (self, parent, name)

        self.setGeometry (0, 0, 500, 370)
        lvLbl = TQLabel ("Offers - text/html", self)
        lvLbl.setGeometry (10, 10, 150, 20)

        lv = TQListView (self)
        lv.setSorting (-1)
        lv.addColumn ("type_", 75)
        lv.addColumn ("name", 100)
        lv.addColumn ("exec_", 200)
        lv.addColumn ("library", 100)
        lv.setGeometry (10, 30, 500, 300)
        lv.setAllColumnsShowFocus (1)

        # insert list items in reverse order

        pref = KServiceTypeProfile.preferredService ("Application", "image/jpeg")
        TQListViewItem (lv, pref.type_ (), pref.name (), pref.exec_ (), pref.library ())
        TQListViewItem (lv, "Preferred", "--------", "", "")
        TQListViewItem (lv, "", "", "", "")

        trader = TDETrader.self ()
        slist = trader.query ("image/jpeg", "Type == 'Application'")
        print "TDETrader returned:", slist
        for s in slist:
            lvi = TQListViewItem (lv, s.type_ (), s.name (), s.exec_ (), s.library ())


        lv.show ()

class KServiceTypeTab (TQWidget):
    def __init__ (self, parent, name = ""):
        TQWidget.__init__ (self, parent, name)

        self.setGeometry (0, 0, 500, 370)
        lvLbl = TQLabel ("All Service Types", self)
        lvLbl.setGeometry (10, 10, 250, 20)

        lv = TQListView (self)
        lv.addColumn ("name", 150)
        lv.addColumn ("desktopEntryPath", 300)
        lv.setGeometry (10, 30, 500, 300)
        lv.setAllColumnsShowFocus (1)

        slist = KServiceType.allServiceTypes ()

        for s in slist:
            lvi = TQListViewItem (lv, s.name (), s.desktopEntryPath ())

        lv.show ()

class KSycocaEntryTab (TQWidget):
    def __init__ (self, parent, name = ""):
        TQWidget.__init__ (self, parent, name)

        grp = KServiceGroup.baseGroup ("screensavers")
        self.setGeometry (0, 0, 500, 370)
        lvLbl = TQLabel ("Entries - 'screensavers': " + grp.name ().latin1 (), self)
        lvLbl.setGeometry (10, 10, 250, 20)

        lv = TQListView (self)
        lv.addColumn ("name", 150)
        lv.addColumn ("entryPath", 300)
        lv.setGeometry (10, 30, 500, 300)
        lv.setAllColumnsShowFocus (1)

        slist = grp.entries (0, 0)

        for s in slist:
            lvi = TQListViewItem (lv, s.name (), s.entryPath ())

        lv.show ()

class KServiceTab (TQWidget):
    def __init__ (self, parent, name = ""):
        TQWidget.__init__ (self, parent, name)

        self.setGeometry (0, 0, 500, 370)
        lvLbl = TQLabel ("All Services", self)
        lvLbl.setGeometry (10, 10, 150, 20)

        lv = TQListView (self)
        lv.addColumn ("type_", 75)
        lv.addColumn ("name", 100)
        lv.addColumn ("exec_", 200)
        lv.addColumn ("library", 100)
        lv.setGeometry (10, 30, 500, 300)
        lv.setAllColumnsShowFocus (1)

        slist = KService.allServices ()
        for s in slist:
            lvi = TQListViewItem (lv, s.type_ (), s.name (), s.exec_ (), s.library ())

        lv.show ()


#        svc = KService.serviceByDesktopName ("kcookiejar")
#        print svc
#        print svc.type_ ()
#        print svc.name ().latin1 ()
#        print svc.exec_ ().latin1 ()
#        print svc.library ()


class KMimeTypeTab (TQWidget):
    def __init__ (self, parent, name = ""):
        TQWidget.__init__ (self, parent, name)

        self.setGeometry (0, 0, 500, 370)
        lbLbl = TQLabel ("All Mimetypes", self)
        lbLbl.setGeometry (10, 10, 150, 20)
        lb = TDEListBox (self)
        lb.setGeometry (10, 30, 200, 300)
        mlist = KMimeType.allMimeTypes ()
        lblist = []
        for mt in mlist:
            lblist.append (mt.name ().latin1 ())

        lblist.sort ()
        lb.insertStrList (lblist)

        lb.show ()

        x = 250
        y = 10

        mt = KMimeType.mimeType ("text/plain")
        mtlbl = TQLabel ("KMimeType.mimeType ('text/plain')", self)
        mtlbl.setGeometry (x, y, 250, 20)
        mtnamelbl = TQLabel ("name", self)
        mtnamelbl.setGeometry (x + 15, y + 20, 100, 20)
        mtname = TQLabel (mt.name (), self)
        mtname.setGeometry (x + 120, y + 20, 100, 20)
        mtdesklbl = TQLabel ("desktopEntryPath", self)
        mtdesklbl.setGeometry (x + 15, y + 40, 100, 20)
        mtdesk = TQLabel (mt.desktopEntryPath (), self)
        mtdesk.setGeometry (x + 120, y + 40, 150, 20)

        y = y + 80

        fp = KMimeType.findByPath ("mimetype.py")
        fplbl = TQLabel ("KMimeType.findByPath ('mimetype.py')", self)
        fplbl.setGeometry (x, y, 250, 20)
        fpnamelbl = TQLabel ("name", self)
        fpnamelbl.setGeometry (x + 15, y + 20, 100, 20)
        fpname = TQLabel (fp.name (), self)
        fpname.setGeometry (x + 120, y + 20, 100, 20)
        fpdesklbl = TQLabel ("desktopEntryPath", self)
        fpdesklbl.setGeometry (x + 15, y + 40, 100, 20)
        fpdesk = TQLabel (fp.desktopEntryPath (), self)
        fpdesk.setGeometry (x + 120, y + 40, 150, 20)

        y = y + 80

        fu = KMimeType.findByURL (KURL ("file://mimetype.py"))
        fulbl = TQLabel ("KMimeType.findByURL ('file://mimetype.py')", self)
        fulbl.setGeometry (x, y, 250, 20)
        funamelbl = TQLabel ("name", self)
        funamelbl.setGeometry (x + 15, y + 20, 100, 20)
        funame = TQLabel (fu.name (), self)
        funame.setGeometry (x + 120, y + 20, 100, 20)
        fudesklbl = TQLabel ("desktopEntryPath", self)
        fudesklbl.setGeometry (x + 15, y + 40, 100, 20)
        fudesk = TQLabel (fu.desktopEntryPath (), self)
        fudesk.setGeometry (x + 120, y + 40, 150, 20)

        y = y + 80

        fc, acc = KMimeType.findByFileContent ("mimetype.py")
        fclbl = TQLabel ("KMimeType.findByFileContent ('mimetype.py')", self)
        fclbl.setGeometry (x, y, 250, 20)
        fcnamelbl = TQLabel ("name", self)
        fcnamelbl.setGeometry (x + 15, y + 20, 100, 20)
        fcname = TQLabel (fc.name (), self)
        fcname.setGeometry (x + 120, y + 20, 100, 20)
        fcdesklbl = TQLabel ("desktopEntryPath", self)
        fcdesklbl.setGeometry (x + 15, y + 40, 100, 20)
        fcdesk = TQLabel (fc.desktopEntryPath (), self)
        fcdesk.setGeometry (x + 120, y + 40, 100, 20)
        fcacclbl = TQLabel ("accuracy", self)
        fcacclbl.setGeometry (x + 15, y + 60, 100, 20)
        fcacc = TQLabel (str (acc), self)
        fcacc.setGeometry (x + 120, y + 60, 150, 20)



#-------------------- main ------------------------------------------------

description = "Test/demo TDESharedPtr related methods/classes"
version     = "1.0"
aboutData   = TDEAboutData ("", "",\
    version, description, TDEAboutData.License_GPL,\
    "(C) 2003 Jim Bublitz")

TDECmdLineArgs.init (sys.argv, aboutData)

TDECmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = TDEApplication ()
mainWindow = MainWin (None, "main window")
mainWindow.show()
app.exec_loop()
