/* ============================================================
 * File  : gpcamera.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-01-21
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef GPCAMERA_H
#define GPCAMERA_H

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqvaluelist.h>

#include "gpfileiteminfo.h"

class TQImage;

namespace KIPIKameraKlientPlugin
{

class GPCameraPrivate;
class GPStatus;

class GPCamera {

public:
    enum {
        GPError=0,
        GPInit,
        GPSetup,
        GPSuccess
    } Errors;
    

    GPCamera(const TQString& model, const TQString& port);
    ~GPCamera();

    bool thumbnailSupport();
    bool deleteSupport();
    bool uploadSupport();
    bool mkDirSupport();
    bool delDirSupport();

    int  initialize();

    void cancel();

    int getSubFolders(const TQString& folder, TQValueList<TQString>& subFolderList);

    void getAllItemsInfo(const TQString& folder, GPFileItemInfoList& infoList);
    int getItemsInfo(const TQString& folder, GPFileItemInfoList& infoList);
    int getThumbnail(const TQString& folder, const TQString& imageName, TQImage& thumbnail);
    int downloadItem(const TQString& folder, const TQString& itemName, const TQString& saveFile);
    int deleteItem(const TQString& folder, const TQString& itemName);

    // recursively delete all items
    int deleteAllItems(const TQString& folder);
    int uploadItem(const TQString& folder, const TQString& itemName, const TQString& localFile);
    void cameraSummary(TQString& summary);
    void cameraManual(TQString& manual);
    void cameraAbout(TQString& about);
    
    // Static Functions
    static void getSupportedCameras(int& count, TQStringList& clist);
    static void getSupportedPorts(TQStringList& plist);
    static void getCameraSupportedPorts(const TQString& model, TQStringList& plist);
    static int  autoDetect(TQString& model, TQString& port);
    
private:
    int  setup();
    GPCameraPrivate *d;
    GPStatus        *status;
};

}  // NameSpace KIPIKameraKlientPlugin

#endif

