
# Trinity-specific paths
import sys, os
tqt_modules = []
for m_path in sys.path:
    if os.path.exists(os.path.join(m_path, 'sip4_tqt')):
        m_sip_dir = os.path.join(m_path, 'sip4_tqt')
        tqt_modules.insert(0, m_sip_dir)
    if os.path.exists(os.path.join(m_path, 'python_tqt')):
        m_pyqt_dir = os.path.join(m_path, 'python_tqt')
        tqt_modules.insert(0, m_pyqt_dir)
for m_path in tqt_modules:
    sys.path.insert(0, m_path)

# Base modules
__all__ = [
 'qt',
 'qtcanvas',
 'qtnetwork',
 'qtsql',
 'qttable',
 'qtui',
 'qtxml',
]

# Optional modules
if os.path.exists(os.path.join(m_pyqt_dir, 'qtaxcontainer.so')):
    __all__.append('qtaxcontainer')
if os.path.exists(os.path.join(m_pyqt_dir, 'qtext.so')):
    __all__.append('qtext')
if os.path.exists(os.path.join(m_pyqt_dir, 'qtgl.so')):
    __all__.append('qtgl')

# Import namespaces
from python_tqt import *
