#!/usr/bin/env python
#/****************************************************************************
#** $Id: buttongroups.py,v 1.2 2002/12/20 18:46:10 phil Exp $
#**
#** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
#**
#** This file is part of an example program for TQt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys
from python_tqt.qt import *

TRUE  = 1
FALSE = 0

##
# Creates all child widgets of the ButtonGroups window
##

class ButtonsGroups( TQWidget ):
  def __init__( self, *args ):
    apply( TQWidget.__init__, (self,) + args )

    # Create Widgets which allow easy layouting
    self.vbox = TQVBoxLayout( self, 11, 6 )
    self.box1 = TQHBoxLayout( self.vbox )
    self.box2 = TQHBoxLayout( self.vbox )

    # ------- first group

    # Create an exclusive button group
    self.grp1 = TQButtonGroup( 1, TQGroupBox.Horizontal, "Button Group 1 (exclusive)", self )
    self.box1.addWidget( self.grp1 )
    self.grp1.setExclusive( TRUE )

    # insert 3 radiobuttons
    self.rb11 = TQRadioButton( "&Radiobutton 1", self.grp1 )
    self.rb11.setChecked( TRUE )
    TQRadioButton( "R&adiobutton 2", self.grp1 )
    TQRadioButton( "Ra&diobutton 3", self.grp1 )

    # ------- second group

    # Create a non-exclusive buttongroup
    self.grp2 = TQButtonGroup( 1, TQGroupBox.Horizontal, "Button Group 2 (non-exclusive)", self )
    self.box1.addWidget( self.grp2 )
    self.grp2.setExclusive( FALSE )

    # insert 3 checkboxes
    TQCheckBox( "&Checkbox 1", self.grp2 )
    self.cb12 = TQCheckBox( "C&heckbox 2", self.grp2 )
    self.cb12.setChecked( TRUE )
    self.cb13 = TQCheckBox( "Triple &State Button", self.grp2 )
    self.cb13.setTristate( TRUE )
    self.cb13.setChecked( TRUE )

    # ------------ third group

    # create a buttongroup which is exclusive for radiobuttons and non-exclusive for all other buttons
    self.grp3 = TQButtonGroup( 1, TQGroupBox.Horizontal, "Button Group 3 (Radiobutton-exclusive)", self )
    self.box2.addWidget( self.grp3 )
    self.grp3.setRadioButtonExclusive( TRUE )

    # insert three radiobuttons
    self.rb21 = TQRadioButton( "Rad&iobutton 1", self.grp3 )
    self.rb22 = TQRadioButton( "Radi&obutton 2", self.grp3 )
    self.rb23 = TQRadioButton( "Radio&button 3", self.grp3 )
    self.rb23.setChecked( TRUE )

    # insert a checkbox...
    self.state = TQCheckBox( "E&nable Radiobuttons", self.grp3 )
    self.state.setChecked( TRUE )
    # ...and connect its SIGNAL clicked() with the SLOT slotChangeGrp3State()
    self.connect( self.state, SIGNAL( "clicked()" ), self.slotChangeGrp3State )

    # ------------ fourth group

    # create a groupbox which layouts its childs in a columns
    self.grp4 = TQButtonGroup( 1, TQGroupBox.Horizontal, "Groupbox with normal buttons", self )
    self.box2.addWidget( self.grp4 )

    # insert two pushbuttons...
    TQPushButton( "&Push Button", self.grp4 )
    self.tb2 = TQPushButton( "&Toggle Button", self.grp4 )

    # ... and make the second one a toggle button
    self.tb2.setToggleButton( TRUE )
    self.tb2.setOn( TRUE )

    # ... and make the third one a flat button
    self.tb3 = TQPushButton( "&Flat Button", self.grp4 )
    self.tb3.setFlat( TRUE )

    # .. and the fourth a button with a menu
    self.tb4 = TQPushButton( "Popup Button", self.grp4 )
    menu = TQPopupMenu(self.tb4)
    menu.insertItem("Item1", 0)
    menu.insertItem("Item2", 0)
    menu.insertItem("Item3", 0)
    menu.insertItem("Item4", 0)
    self.tb4.setPopup(menu)

    #
    # SLOT slotChangeGrp3State()
    # enables/disables the radiobuttons of the third buttongroup
    #

  def slotChangeGrp3State( self ):
    self.rb21.setEnabled( self.state.isChecked() )
    self.rb22.setEnabled( self.state.isChecked() )
    self.rb23.setEnabled( self.state.isChecked() )


## main program
a = TQApplication( sys.argv )

buttonsgroups = ButtonsGroups()
buttonsgroups.resize( 500, 250 )
buttonsgroups.setCaption( "PyQT Example - Buttons and Groups" )
a.setMainWidget( buttonsgroups )
buttonsgroups.show()

a.exec_loop()
